/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.button;

import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.input.validation.SwingValidator;
import com.schneide.base.input.validation.ValidationAspect;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class GenericValidatingDialogButtonHandler
implements DialogButtonHandler {
    private final SwingValidator validator;

    public GenericValidatingDialogButtonHandler(AbstractSchneideDialog dialog) {
        this(dialog.createValidator());
    }

    public GenericValidatingDialogButtonHandler(JWindow window) {
        this(new SwingValidator(window, new ValidationAspect[0]));
    }

    public GenericValidatingDialogButtonHandler(JDialog dialog) {
        this(new SwingValidator(dialog, new ValidationAspect[0]));
    }

    public GenericValidatingDialogButtonHandler(JPanel panel) {
        this(new SwingValidator(panel, new ValidationAspect[0]));
    }

    public GenericValidatingDialogButtonHandler(SwingValidator validator) {
        this.validator = validator;
    }

    @Override
    public final boolean handleDialogButtonActivation(JButton button) {
        if (!this.handleDialogButtonBeforeValidation(button)) {
            return false;
        }
        if (!this.handleValidation(button)) {
            return false;
        }
        return this.handleDialogButtonAfterValidation(button);
    }

    protected boolean handleDialogButtonAfterValidation(JButton button) {
        return true;
    }

    protected boolean handleDialogButtonBeforeValidation(JButton button) {
        return true;
    }

    protected boolean handleValidation(JButton button) {
        return true == this.validator.performSwingValidation();
    }
}

