/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog.button;

import com.schneide.base.gui.dialog.button.DialogButtonHandler;
import com.schneide.base.gui.dialog.model.DialogButtonHook;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.text.Text;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public abstract class DialogButton
extends JButton
implements DialogButtonHandler {
    private static final long serialVersionUID = -5171971558760461497L;
    private final List<DialogButtonHook> buttonHookList;
    private boolean isHidden;

    public DialogButton(DisplayInformation displayInformation, boolean isHidden) {
        super(displayInformation.getTitle());
        this.isHidden = isHidden;
        this.buttonHookList = new ArrayList<DialogButtonHook>();
        if (!Text.isEmpty(displayInformation.getTooltip())) {
            this.setToolTipText(displayInformation.getTooltip());
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean newState) {
        this.isHidden = newState;
    }

    @Override
    public boolean handleDialogButtonActivation(JButton button) {
        if (button == this) {
            return this.performButtonAction();
        }
        return false;
    }

    public abstract boolean performButtonAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButtonHook(DialogButtonHook hook) {
        if (hook != null) {
            List<DialogButtonHook> list = this.buttonHookList;
            synchronized (list) {
                this.buttonHookList.add(hook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeButtonHook(DialogButtonHook hook) {
        if (hook != null) {
            List<DialogButtonHook> list = this.buttonHookList;
            synchronized (list) {
                this.buttonHookList.remove(hook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogButtonHook[] getButtonHooks() {
        List<DialogButtonHook> list = this.buttonHookList;
        synchronized (list) {
            return this.buttonHookList.toArray(new DialogButtonHook[this.buttonHookList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllButtonHooks() {
        List<DialogButtonHook> list = this.buttonHookList;
        synchronized (list) {
            this.buttonHookList.clear();
        }
    }
}

