/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog;

import com.schneide.base.datatypes.collections.ArrayUtil;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class DialogMessage {
    private final String text;
    private final String[] textLines;
    private final Color color;

    public DialogMessage() {
        this("");
    }

    public DialogMessage(String text) {
        this(text, Color.BLACK);
    }

    public DialogMessage(String text, Color color) {
        this.text = text;
        this.textLines = this.extractLines(text);
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getText() {
        return this.text;
    }

    public int getLinesCount() {
        return this.textLines.length;
    }

    public String[] getTextLines() {
        return ArrayUtil.copy(this.textLines);
    }

    public JLabel[] getLabels() {
        String[] currentLines = this.getTextLines();
        JLabel[] result = new JLabel[currentLines.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new JLabel(currentLines[i]);
            result[i].setForeground(this.getColor());
        }
        return result;
    }

    private String[] extractLines(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken();
        }
        return result;
    }
}

