/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog;

import com.schneide.base.i18n.I18NKey;
import com.schneide.base.logging.LoggedObject;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;

public class AbstractSchneideFrame
extends LoggedObject {
    private JFrame frame;
    private final I18NKey i18nContext;

    public AbstractSchneideFrame(I18NKey i18nContext) {
        this(i18nContext, "title");
    }

    public AbstractSchneideFrame(I18NKey i18nContext, String titleKey) {
        this.i18nContext = i18nContext;
        if (!GraphicsEnvironment.isHeadless()) {
            this.frame = new JFrame();
            this.frame.setTitle(this.getContextText(titleKey));
        }
    }

    private JFrame getFrame() {
        return this.frame;
    }

    private boolean hasFrame() {
        return this.frame != null;
    }

    protected final I18NKey getI18NContext() {
        return this.i18nContext;
    }

    protected final I18NKey getKeyInContext(String key) {
        return new I18NKey(this.getI18NContext(), key);
    }

    protected final String getContextText(String key) {
        return this.getKeyInContext(key).resolvedText();
    }

    public void setContentPane(Container contentPane) {
        if (this.hasFrame()) {
            this.getFrame().setContentPane(contentPane);
        }
    }

    public void setVisible(boolean b) {
        if (this.hasFrame()) {
            this.getFrame().setVisible(b);
        }
    }

    public void pack() {
        if (this.hasFrame()) {
            this.getFrame().pack();
        }
    }

    public void makeVisible() {
        this.pack();
        this.setVisible(true);
    }
}

