/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.dialog;

import com.schneide.base.gui.GenericWindowStack;
import com.schneide.base.gui.dialog.DialogButtonAdder;
import com.schneide.base.gui.dialog.DialogCloseListener;
import com.schneide.base.gui.dialog.DialogMessage;
import com.schneide.base.gui.dialog.DialogNotification;
import com.schneide.base.gui.dialog.GenericDialogOption;
import com.schneide.base.gui.dialog.SchneideDialog;
import com.schneide.base.gui.dialog.SwingInternalSchneideDialog;
import com.schneide.base.gui.dialog.button.ButtonRole;
import com.schneide.base.gui.dialog.button.DialogButton;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.dialog.model.DialogButtonHook;
import com.schneide.base.gui.dialog.model.DialogOption;
import com.schneide.base.gui.help.ContextHelpProvider;
import com.schneide.base.gui.help.DefaultTransientContextHelpProvider;
import com.schneide.base.gui.help.HelpIDAndComponentProvider;
import com.schneide.base.gui.help.HelpIDProvider;
import com.schneide.base.gui.help.HelpIDProviderCollector;
import com.schneide.base.gui.i18n.I18NContext;
import com.schneide.base.gui.lifecycle.GenericListenerRelationHandler;
import com.schneide.base.gui.lifecycle.ListenerRelation;
import com.schneide.base.gui.lifecycle.ListenerRelationHandler;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.helper.InputUtil;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.StringGridBagLayoutStrategy;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.SwingValidator;
import com.schneide.base.input.validation.ValidationAspect;
import com.schneide.base.input.validation.ValidationAspectHolder;
import com.schneide.base.layout.GridBagLayoutPanel;
import com.schneide.base.listener.ListListenerHandler;
import com.schneide.base.util.GetNameOf;
import com.schneide.base.util.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AbstractSchneideDialog<ANSWER>
extends I18NContext
implements SchneideDialog<ANSWER>,
DialogNotification,
ListenerRelationHandler {
    public static final Dialog.ModalityType defaultModality = Dialog.ModalityType.DOCUMENT_MODAL;
    private static final String I18N_TITLE = "title";
    private static final String I18N_MESSAGE = "message";
    private final ValidationAspectHolder validationAspects;
    private final ListListenerHandler<DialogCloseListener> closeListeners;
    private final GenericListenerRelationHandler listenerRelationHandler;
    private SwingInternalSchneideDialog<ANSWER> dialog;
    private ContextHelpProvider contextHelpProvider;
    private boolean isUIBuilt;
    private final WindowStack windowStack;
    private final Dialog.ModalityType modality;

    protected AbstractSchneideDialog() {
        this(GenericWindowStack.getParentlessWindowStack());
    }

    public AbstractSchneideDialog(WindowStack windowStack) throws IllegalArgumentException {
        this(windowStack, defaultModality);
    }

    public AbstractSchneideDialog(WindowStack windowStack, boolean isModal) throws IllegalArgumentException {
        this(windowStack, "", AbstractSchneideDialog.getModalityTypeFor(isModal));
    }

    public AbstractSchneideDialog(WindowStack windowStack, Dialog.ModalityType modality) throws IllegalArgumentException {
        this(windowStack, "", modality);
    }

    public AbstractSchneideDialog(WindowStack windowStack, String directKeyBase) throws IllegalArgumentException {
        this(windowStack, directKeyBase, defaultModality);
    }

    public AbstractSchneideDialog(WindowStack windowStack, String directKeyBase, boolean isModal) throws IllegalArgumentException {
        this(windowStack, (I18NKeyed)new I18NKey(directKeyBase), AbstractSchneideDialog.getModalityTypeFor(isModal));
    }

    public AbstractSchneideDialog(WindowStack windowStack, String directKeyBase, Dialog.ModalityType modality) throws IllegalArgumentException {
        this(windowStack, (I18NKeyed)new I18NKey(directKeyBase), modality);
    }

    public AbstractSchneideDialog(WindowStack windowStack, I18NKeyed keyBase) throws IllegalArgumentException {
        this(windowStack, keyBase, defaultModality);
    }

    public AbstractSchneideDialog(WindowStack windowStack, I18NKeyed keyBase, boolean isModal) throws IllegalArgumentException {
        this(windowStack, keyBase, AbstractSchneideDialog.getModalityTypeFor(isModal));
    }

    public AbstractSchneideDialog(WindowStack windowStack, I18NKeyed keyBase, Dialog.ModalityType modality) throws IllegalArgumentException {
        super(keyBase);
        EDT.whatever();
        this.windowStack = windowStack;
        this.modality = modality;
        this.closeListeners = new ListListenerHandler("dialogCloseListeners");
        this.validationAspects = new ValidationAspectHolder();
        this.contextHelpProvider = new DefaultTransientContextHelpProvider();
        this.listenerRelationHandler = new GenericListenerRelationHandler();
        this.isUIBuilt = false;
    }

    protected void setupUI() {
        EDT.only();
        this.dialog = this.createSwingDialogOn(this.windowStack);
        this.dialog.setName(this.getClass().getName());
        this.getInternalDialog().getDialog().addWindowListener(new WindowCloseListener());
        this.setModality(this.modality);
    }

    protected boolean isBuilt() {
        return this.isUIBuilt;
    }

    public final void prepare() {
        EDT.whatever();
        this.prepareUI();
    }

    protected final void prepareUI() {
        EDT.whatever();
        if (this.isUIBuilt) {
            return;
        }
        EDT.performBlocking(() -> {
            this.setupUI();
            this.buildUI();
            this.applyTouchscreen();
            this.repack();
        });
        this.isUIBuilt = true;
    }

    protected InputFactory inputFactory() {
        return new InputFactory.DesktopInputFactory();
    }

    protected void applyTouchscreen() {
    }

    protected final void setModal(boolean isModal) {
        this.setModality(AbstractSchneideDialog.getModalityTypeFor(isModal));
    }

    protected final void setModality(Dialog.ModalityType modality) {
        this.getInternalDialog().getDialog().setModalityType(modality);
    }

    protected final void setAlwaysOnTop(boolean isAlwaysOnTop) {
        this.getInternalDialog().getDialog().setAlwaysOnTop(isAlwaysOnTop);
    }

    protected abstract void buildUI();

    protected void arrangeUI() {
    }

    protected void destructUI() {
    }

    @Override
    public void addListenerRelation(ListenerRelation relation) {
        this.listenerRelationHandler.addListenerRelation(relation);
    }

    private SwingInternalSchneideDialog<ANSWER> createSwingDialogOn(WindowStack currentStack) {
        Window activeWindow = currentStack.getActiveWindow();
        if (null == activeWindow) {
            return new SwingInternalSchneideDialog((Frame)null, currentStack, this.getDefaultTitle(), (DialogNotification)this, this);
        }
        if (activeWindow instanceof Dialog) {
            return new SwingInternalSchneideDialog((Dialog)activeWindow, currentStack, this.getDefaultTitle(), (DialogNotification)this, this);
        }
        if (activeWindow instanceof Frame) {
            return new SwingInternalSchneideDialog((Frame)activeWindow, currentStack, this.getDefaultTitle(), (DialogNotification)this, this);
        }
        throw new IllegalArgumentException("activeWindow is neither Dialog nor Frame. This should not happen within a Swing application.");
    }

    private static Dialog.ModalityType getModalityTypeFor(boolean isModal) {
        if (isModal) {
            return Dialog.ModalityType.DOCUMENT_MODAL;
        }
        return Dialog.ModalityType.MODELESS;
    }

    protected void disconnectListeners() {
        this.listenerRelationHandler.disconnectListenerRelations();
    }

    public void addCloseListener(DialogCloseListener listener) {
        this.closeListeners.addListener(listener);
    }

    public void removeCloseListener(DialogCloseListener listener) {
        this.closeListeners.removeListener(listener);
    }

    void notifyCloseListeners() {
        this.closeListeners.notifyListeners(listener -> listener.dialogClosed(this));
    }

    protected void setHelpContextID(String helpContextID) {
        this.registerHelpContext(this.getInternalDialog().getDialog().getRootPane(), helpContextID);
    }

    public ContextHelpProvider getHelpContext() {
        return this.contextHelpProvider;
    }

    public void setContextHelpProvider(ContextHelpProvider provider) {
        this.contextHelpProvider.copyTo(provider);
        this.contextHelpProvider = provider;
    }

    protected void registerHelpContext(Component component, String context) {
        this.getHelpContext().register(component, context);
    }

    protected String getDefaultTitle() {
        if (I18NKey.NOT_GIVEN == this.getDefaultTitleKey()) {
            return "";
        }
        return this.getDefaultTitleKey().resolvedText();
    }

    protected final void setDefaultTitle() {
        this.setTitle(this.getDefaultTitle());
    }

    protected I18NKey getDefaultTitleKey() {
        return this.getI18NBase().withKeyPart(I18N_TITLE);
    }

    protected final void setTitle(String text) {
        this.getInternalDialog().getDialog().setTitle(text);
    }

    protected final void setTitle(I18NResolvable title) {
        this.setTitle(title.resolvedText());
    }

    public static String getDefaultCommitButtonTitle() {
        return SwingInternalSchneideDialog.getDefaultCommitButtonTitle();
    }

    public static String getDefaultCancelButtonTitle() {
        return SwingInternalSchneideDialog.getDefaultCancelButtonTitle();
    }

    public static String getDefaultCloseButtonTitle() {
        return SwingInternalSchneideDialog.getDefaultCloseButtonTitle();
    }

    public void addValidationAspects(ValidationAspect ... aspects) {
        for (ValidationAspect aspect : aspects) {
            this.validationAspects.addValidationAspect(aspect);
        }
    }

    public void removeValidationAspects(ValidationAspect ... aspects) {
        for (ValidationAspect aspect : aspects) {
            this.validationAspects.removeValidationAspect(aspect);
        }
    }

    public static boolean askToSkipWarning(WindowStack session, String title, String message, String skipOptionTitle, String cancelOptionTitle) {
        GenericDialogOption skipOption = new GenericDialogOption(skipOptionTitle);
        GenericDialogOption cancelOption = new GenericDialogOption(cancelOptionTitle, true);
        DialogOption[] options = new DialogOption[]{skipOption, cancelOption};
        DialogOption answer = DefaultDialog.showWarningOptionDialog(session, title, message, options);
        return skipOption.equals(answer);
    }

    public Window getDialogWindow() {
        return this.getInternalDialog().getDialog();
    }

    private SwingInternalSchneideDialog<ANSWER> getInternalDialog() {
        if (null == this.dialog) {
            this.getLogger().warn("Preparing dialog UI for internal access from " + GetNameOf.myCallingMethods(3));
            this.prepareUI();
        }
        return this.dialog;
    }

    protected void setHelpButton(JButton button) {
        this.getInternalDialog().setHelpButton(button);
    }

    public SwingValidator createValidator() {
        return new SwingValidator(this.getInternalDialog().getDialog(), this.validationAspects.getValidationAspects());
    }

    public void disableGenericCloseButton() {
        this.getInternalDialog().getDialog().removeWindowListener(this.getInternalDialog());
    }

    @Override
    public boolean isVisible() {
        return this.getInternalDialog().getDialog().isVisible();
    }

    public DialogButton getCancelButton() {
        return this.getInternalDialog().getCancelButton();
    }

    public DialogButton getCommitButton() {
        return this.getInternalDialog().getCommitButton();
    }

    public void addMessage(DialogMessage message) {
        this.getInternalDialog().addMessage(message);
    }

    public void addMessage(String message) {
        if (message.equals(I18N_MESSAGE)) {
            return;
        }
        this.getInternalDialog().addMessage(message);
    }

    public void addMessage(I18NResolvable message) {
        this.getInternalDialog().addMessage(message.resolvedText());
    }

    protected String getDefaultI18NMessage() {
        return this.getTextEntry(I18N_MESSAGE);
    }

    public void addDefaultI18NMessage() {
        String defaultMessage = this.getDefaultI18NMessage();
        if (defaultMessage.equals(I18N_MESSAGE)) {
            this.getLogger().debug("Keine passende Dialognachricht in den I18N-Dateien gefunden.");
            return;
        }
        this.addMessage(defaultMessage);
    }

    public void addI18NMessage(String i18nKeyPart) {
        this.addMessage(this.getTextEntry(i18nKeyPart));
    }

    public void addMessage(String message, Color color) {
        this.getInternalDialog().addMessage(message, color);
    }

    public void addI18NMessage(String i18nKeyPart, Color color) {
        this.addMessage(this.getTextEntry(i18nKeyPart), color);
    }

    @Override
    public void closeDialog(DialogButton button) {
        this.getInternalDialog().closeDialog(button);
    }

    public DialogButton getCloseButton() {
        return this.getInternalDialog().getCloseButton();
    }

    @Override
    public void hideDialog() {
        this.getInternalDialog().hideDialog();
    }

    public void setDefaultButton(DialogButton button) {
        this.getInternalDialog().setDefaultButton(button);
    }

    public void setContent(JPanel contentPanel) {
        this.getInternalDialog().setDialogContent(contentPanel);
    }

    public void setNonCollapsable() {
        this.getInternalDialog().setNonCollapsable();
    }

    public JPanel getContent() {
        return this.getInternalDialog().getDialogContent();
    }

    @Override
    public Optional<ANSWER> showDialog() {
        EDT.performBlocking(() -> {
            this.prepareUI();
            this.listenerRelationHandler.connectListenerRelations();
            this.getInternalDialog().showDialog();
            this.registerHelpContexts();
        });
        return this.provideAnswer();
    }

    protected Optional<ANSWER> provideAnswer() {
        if (!this.wasClosedByCommit()) {
            return Optional.empty();
        }
        return this.giveAnswer();
    }

    protected abstract Optional<ANSWER> giveAnswer();

    private void registerHelpContexts() {
        HelpIDProvider[] providers;
        for (HelpIDProvider provider : providers = HelpIDProviderCollector.getHelpIDProviderFor(this.getInternalDialog().getDialog().getRootPane())) {
            Component component = null;
            if (provider instanceof Component) {
                component = (Component)((Object)provider);
            } else if (provider instanceof HelpIDAndComponentProvider) {
                component = ((HelpIDAndComponentProvider)provider).getComponent();
            }
            if (null == component) continue;
            this.registerHelpContext(component, provider.getHelpContextID());
        }
    }

    public boolean wasClosedBy(DialogButton button) {
        return this.getInternalDialog().wasClosedBy(button);
    }

    public void addHookForClose(DialogButtonHook hook) {
        this.addHook(hook, this.getInternalDialog().getCloseButton());
    }

    public void addHookForCommit(DialogButtonHook hook) {
        this.addHook(hook, this.getInternalDialog().getCommitButton());
    }

    public void addHookForCancel(DialogButtonHook hook) {
        this.addHook(hook, this.getInternalDialog().getCancelButton());
    }

    private void addHook(DialogButtonHook hook, DialogButton button) {
        if (button != null) {
            button.addButtonHook(hook);
        }
    }

    protected JPanel buildInputContent(Input ... inputs) {
        return this.buildInputContent(Arrays.asList(inputs));
    }

    protected JPanel buildInputContent(Iterable<Input> inputs) {
        GridBagLayoutPanel content = new GridBagLayoutPanel();
        StringGridBagLayoutStrategy layoutStrategy = new StringGridBagLayoutStrategy();
        for (Input input : inputs) {
            input.addToPanel(content, layoutStrategy);
        }
        return content;
    }

    protected void buildInputDialog(String message, Input[] inputs, String commitButtonTitle) {
        this.buildMainInputDialogContent(message, inputs);
        this.addButton().commitButton(commitButtonTitle, "");
        this.addButton().cancelButton();
    }

    protected void buildInputDialog(String message, Input[] inputs, DialogButton commitButton) {
        this.buildMainInputDialogContent(message, inputs);
        this.addButton().commitButton(commitButton);
        this.addButton().cancelButton();
    }

    protected void buildMainInputDialogContent(String message, Input ... inputs) {
        this.buildMainInputDialogContent(message, Arrays.asList(inputs));
    }

    protected void buildMainInputDialogContent(String message, Iterable<Input> inputs) {
        this.addMessage(message);
        JPanel content = this.buildInputContent(inputs);
        this.setContent(content);
    }

    protected void buildDefaultI18NInputDialog(Value ... values) {
        this.buildDefaultInputDialog(this.getI18NBase().withKeyPart(I18N_MESSAGE), values);
    }

    protected void buildDefaultInputDialog(String message, Value ... values) {
        this.buildInputDialog(message, InputUtil.createDefaultInputsFor(this.inputFactory(), values));
    }

    protected void buildDefaultInputDialog(I18NKey message, Value ... values) {
        this.buildDefaultInputDialog(message.resolvedText(), values);
    }

    protected void buildInputDialog(String message, Input ... inputs) {
        this.buildInputDialog(message, Arrays.asList(inputs));
    }

    protected void buildInputDialog(String message, Iterable<Input> inputs) {
        this.buildMainInputDialogContent(message, inputs);
        this.addButton().commitCancelButtons();
    }

    public DialogButtonAdder addButton() {
        return new DialogButtonAdder(this, this.getInternalDialog(), this.getI18NBase());
    }

    @Override
    public boolean wasClosedByCancel() {
        return this.getInternalDialog().wasClosedByCancel();
    }

    @Override
    public boolean wasClosedByCommit() {
        return this.getInternalDialog().wasClosedByCommit();
    }

    protected WindowStack getWindowStack() {
        return this.windowStack;
    }

    @Override
    public void repack() {
        EDT.only();
        this.getInternalDialog().getDialog().pack();
    }

    public void disposeWithoutClosing() {
        if (!this.isVisible()) {
            this.dialog.getDialog().dispose();
        }
    }

    public void disposeOnClose() {
        EDT.performBlocking(() -> this.dialog.getDialog().setDefaultCloseOperation(2));
    }

    protected boolean hasButtons() {
        return this.getInternalDialog().hasButtons();
    }

    public void removeAllButtons() {
        this.getInternalDialog().removeAllButtons();
    }

    @Override
    public final boolean wantsToCloseWith(DialogButton source) {
        ButtonRole role = ButtonRole.optional;
        if (source.equals(this.getCommitButton())) {
            role = ButtonRole.commit;
        }
        if (source.equals(this.getCancelButton())) {
            role = ButtonRole.cancel;
        }
        return CloseDecision.proceed == this.canCloseWith(source, role);
    }

    protected CloseDecision canCloseWith(DialogButton source, ButtonRole role) {
        Parameter.arePresent(new Object[]{source, role});
        return CloseDecision.proceed;
    }

    private class WindowCloseListener
    extends WindowAdapter {
        @Override
        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
            AbstractSchneideDialog.this.notifyCloseListeners();
            AbstractSchneideDialog.this.disconnectListeners();
            AbstractSchneideDialog.this.destructUI();
        }
    }

    protected static enum CloseDecision {
        proceed,
        veto;

    }
}

