/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.value;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.data.value.AbstractFilteringListValue;
import com.schneide.base.gui.data.value.ObservableManager;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.util.filter.ReadableFilter;
import java.util.List;

public class ManagerListValueAdapter<ELEMENT>
extends AbstractFilteringListValue<ELEMENT>
implements ObservableManager.ManagerListener<ELEMENT> {
    private final ObservableManager<ELEMENT> manager;
    private final List<ELEMENT> cachedElements;

    public ManagerListValueAdapter(Class<ELEMENT> type, ObservableManager<ELEMENT> manager) {
        this(type, manager, AbstractFilteringListValue.DEFAULT_FILTER);
    }

    public ManagerListValueAdapter(Class<ELEMENT> type, ObservableManager<ELEMENT> manager, ReadableFilter<ELEMENT> initialFilter) {
        this(type, manager, manager.allElements(), initialFilter);
    }

    protected ManagerListValueAdapter(Class<ELEMENT> type, ObservableManager<ELEMENT> manager, Iterable<ELEMENT> initalElements, ReadableFilter<ELEMENT> initialFilter) {
        super(type, initialFilter);
        this.manager = manager;
        this.cachedElements = IterableUtil.asList(initalElements);
    }

    @Override
    public void init() {
        this.manager.addManagerListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.manager.removeManagerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ELEMENT> getUnfilteredElements() {
        List<ELEMENT> list = this.cachedElements;
        synchronized (list) {
            return List.copyOf(this.cachedElements);
        }
    }

    @Override
    public void elementAdded(ELEMENT element) {
        EDT.perform(() -> {
            List<ELEMENT> list = this.cache();
            synchronized (list) {
                this.addToCache(element);
                this.addToFilter(element);
                this.fireElementAdded(element);
            }
        });
    }

    protected void addToCache(ELEMENT newElement) {
        this.cache().add(newElement);
    }

    protected List<ELEMENT> cache() {
        return this.cachedElements;
    }

    @Override
    public void elementRemoved(ELEMENT element) {
        EDT.perform(() -> {
            List<ELEMENT> list = this.cachedElements;
            synchronized (list) {
                int index = this.indexOf(element);
                this.cachedElements.remove(element);
                this.removeFromFilter(element);
                this.fireElementRemoved(element, index);
            }
        });
    }

    @Override
    public void elementUpdated(ELEMENT element) {
        EDT.perform(() -> {
            if (!this.cachedElements.contains(element)) {
                this.getLogger().warn("Inconsistent state of cache in ManagerListValueAdapter");
                return;
            }
            this.updateCachedElement(element, this.cachedElements.indexOf(element));
            int index = this.indexOf(element);
            this.clearFilterCache();
            if (this.getFilter().accept(element)) {
                this.fireElementUpdated(element);
            } else {
                this.fireElementRemoved(element, index);
            }
        });
    }

    private void updateCachedElement(ELEMENT element, int index) {
        this.cachedElements.set(index, element);
    }
}

