/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.value;

import com.schneide.base.gui.data.value.ObservableManager;
import com.schneide.base.listener.ListListenerHandler;
import com.schneide.base.listener.ListenerHandler;
import com.schneide.base.listener.Notifier;
import com.schneide.base.logging.LoggedObject;

public abstract class AbstractObservableManager<ELEMENT>
extends LoggedObject
implements ObservableManager<ELEMENT> {
    private final ListenerHandler<ObservableManager.ManagerListener<ELEMENT>> listeners = new ListListenerHandler<ObservableManager.ManagerListener<ELEMENT>>();

    protected AbstractObservableManager() {
    }

    @Override
    public void addManagerListener(ObservableManager.ManagerListener<ELEMENT> l) {
        this.listeners.addListener(l);
    }

    @Override
    public void removeManagerListener(ObservableManager.ManagerListener<ELEMENT> l) {
        this.listeners.removeListener(l);
    }

    protected void fireElementAdded(ELEMENT element) {
        this.performNotificationFor(this.listeners, listener -> listener.elementAdded(element));
    }

    protected void fireElementRemoved(ELEMENT element) {
        this.performNotificationFor(this.listeners, listener -> listener.elementRemoved(element));
    }

    protected void fireElementUpdated(ELEMENT element) {
        this.performNotificationFor(this.listeners, listener -> listener.elementUpdated(element));
    }

    protected void performNotificationFor(ListenerHandler<ObservableManager.ManagerListener<ELEMENT>> currentListeners, Notifier<ObservableManager.ManagerListener<ELEMENT>> notifier) {
        currentListeners.notifyListeners(notifier);
    }
}

