/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.value;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.gui.data.value.ListChangeListener;
import com.schneide.base.gui.data.value.ListValue;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListValue<E>
extends LoggedObject
implements ListValue<E> {
    private final List<ListChangeListener<E>> listeners = new ArrayList<ListChangeListener<E>>();
    private int maximumSize = Integer.MAX_VALUE;

    protected AbstractListValue() {
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListChangeListener(ListChangeListener<E> l) {
        List<ListChangeListener<E>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListChangeListener<E>[] getListeners() {
        List<ListChangeListener<E>> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new ListChangeListener[this.listeners.size()]);
        }
    }

    protected void fireElementsReplaced() {
        for (ListChangeListener<E> l : this.getListeners()) {
            l.elementsReplaced();
        }
    }

    protected void fireElementAdded(E element) {
        int indexOfAddedElement = this.indexOf(element);
        if (-1 == indexOfAddedElement) {
            return;
        }
        for (ListChangeListener<E> l : this.getListeners()) {
            l.elementAdded(element, indexOfAddedElement);
        }
    }

    protected void fireElementRemoved(E element, int index) {
        for (ListChangeListener<E> l : this.getListeners()) {
            l.elementRemoved(element, index);
        }
    }

    protected void fireElementUpdated(E element) {
        int indexOfUpdatedElement = this.indexOf(element);
        if (-1 == indexOfUpdatedElement) {
            return;
        }
        for (ListChangeListener<E> l : this.getListeners()) {
            l.elementUpdated(element, indexOfUpdatedElement);
        }
    }

    protected abstract Iterable<E> getElements();

    @Override
    public E getElementAt(int index) {
        return IterableUtil.getElementAt(index, this.getElements());
    }

    public void setMaximumSize(int maximumSize) {
        if (maximumSize < 0) {
            return;
        }
        this.maximumSize = maximumSize;
        this.fireElementsReplaced();
    }

    public void resetMaximumSize() {
        this.maximumSize = Integer.MAX_VALUE;
        this.fireElementsReplaced();
    }

    @Override
    public int getSize() {
        return Math.min(IterableUtil.getSizeFor(this.getElements()), this.maximumSize);
    }

    @Override
    public int indexOf(E element) {
        int index = 0;
        for (E each : this.getElements()) {
            if (element.equals(each)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListChangeListener(ListChangeListener<E> l) {
        List<ListChangeListener<E>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

