/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.value;

import com.schneide.base.gui.data.value.AbstractListValue;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.util.filter.FilterArray;
import com.schneide.base.util.filter.NotNullFilter;
import com.schneide.base.util.filter.ReadableFilter;
import java.util.List;

public abstract class AbstractFilteringListValue<ELEMENT>
extends AbstractListValue<ELEMENT> {
    protected static final ReadableFilter<?> DEFAULT_FILTER = new NotNullFilter(new I18NText("filter.all", new Object[0]));
    private ReadableFilter<ELEMENT> filter;
    private List<ELEMENT> filteredElements;
    private final Class<ELEMENT> elementClass;

    protected AbstractFilteringListValue(Class<ELEMENT> elementClass) {
        this(elementClass, DEFAULT_FILTER);
    }

    protected AbstractFilteringListValue(Class<ELEMENT> elementClass, ReadableFilter<ELEMENT> initialFilter) {
        this.elementClass = elementClass;
        this.filter = initialFilter;
        this.clearFilterCache();
    }

    protected Class<ELEMENT> getElementClass() {
        return this.elementClass;
    }

    protected void clearFilterCache() {
        this.filteredElements = null;
    }

    protected void addToFilter(ELEMENT element) {
        if (this.filteredElements == null) {
            return;
        }
        this.filteredElements.add(element);
    }

    protected void removeFromFilter(ELEMENT element) {
        if (this.filteredElements == null) {
            return;
        }
        this.filteredElements.remove(element);
    }

    public void setFilter(ReadableFilter<ELEMENT> filter) {
        this.filter = filter;
        this.clearFilterCache();
        this.fireElementsReplaced();
    }

    public ReadableFilter<ELEMENT> getFilter() {
        return this.filter;
    }

    protected abstract List<ELEMENT> getUnfilteredElements();

    @Override
    protected final Iterable<ELEMENT> getElements() {
        if (null == this.filteredElements) {
            this.filteredElements = FilterArray.withList(this.filter, this.getUnfilteredElements(), this.elementClass);
        }
        return List.copyOf(this.filteredElements);
    }

    @Override
    protected void fireElementAdded(ELEMENT element) {
        if (!this.getFilter().accept(element)) {
            return;
        }
        this.clearFilterCache();
        super.fireElementAdded(element);
    }

    @Override
    protected void fireElementsReplaced() {
        this.clearFilterCache();
        super.fireElementsReplaced();
    }
}

