/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.component.CellRendererLabel;
import com.schneide.base.gui.component.table.TableColorProviderFactory;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.i18n.EmptyText;
import com.schneide.base.i18n.model.I18NResolvable;
import javax.swing.JComponent;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeRenderer
extends AbstractAsynchronousRenderer<DateTime> {
    private static final long serialVersionUID = -8349441413304768164L;
    private final transient DateTimeFormatter formatter;
    private int alignment;
    private final I18NResolvable invalidValueText;

    public DateTimeRenderer() {
        this(DateTimeRenderer.createDefaultFormatter(), (I18NResolvable)new EmptyText());
    }

    public DateTimeRenderer(TableColorProviderFactory<DataResult<?, DateTime>> factory) {
        this(factory, (I18NResolvable)new EmptyText());
    }

    public DateTimeRenderer(TableColorProviderFactory<DataResult<?, DateTime>> factory, I18NResolvable invalidValueText) {
        this(DateTimeRenderer.createDefaultFormatter(), invalidValueText, factory);
    }

    public DateTimeRenderer(DateTimeFormatter formatter, I18NResolvable invalidValueText) {
        this(formatter, invalidValueText, new TableColorProviderFactory());
    }

    public DateTimeRenderer(DateTimeFormatter formatter, I18NResolvable invalidValueText, TableColorProviderFactory<DataResult<?, DateTime>> factory) {
        super(factory);
        this.formatter = formatter;
        this.invalidValueText = invalidValueText;
        this.alignment = 10;
    }

    protected static DateTimeFormatter createDefaultFormatter() {
        return DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm");
    }

    public void setTextAlignment(int textAlignment) {
        this.alignment = textAlignment;
    }

    @Override
    protected JComponent getComponentFor(DateTime dateTime) {
        CellRendererLabel label = new CellRendererLabel(this.getTextValueFor(dateTime));
        label.setHorizontalAlignment(this.alignment);
        return label;
    }

    protected String getTextValueFor(DateTime dateTime) {
        if (!this.isValidValue(dateTime)) {
            return this.invalidValueText.resolvedText();
        }
        return this.getTextForValid(dateTime);
    }

    protected String getTextForValid(DateTime dateTime) {
        return this.formatter.print((ReadableInstant)dateTime);
    }

    protected boolean isValidValue(DateTime dateTime) {
        return null != dateTime && dateTime.isAfter(0L);
    }

    @Override
    public String renderAsText(DateTime value) {
        return this.getTextValueFor(value);
    }
}

