/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.gui.data.renderer.Converter;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.system.Base;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConvertingValueRenderer<SOURCETYPE, TARGETTYPE>
extends AbstractAsynchronousRenderer<SOURCETYPE> {
    private static final long serialVersionUID = 3119787913019346017L;
    private final Converter<SOURCETYPE, TARGETTYPE> converter;
    private final AbstractAsynchronousRenderer<TARGETTYPE> innerRenderer;

    public ConvertingValueRenderer(Converter<SOURCETYPE, TARGETTYPE> converter, AbstractAsynchronousRenderer<TARGETTYPE> innerRenderer) {
        this.converter = converter;
        this.innerRenderer = innerRenderer;
    }

    @Override
    protected JComponent getComponentFor(SOURCETYPE value) {
        try {
            return this.innerRenderer.getComponentFor(this.converted(value));
        }
        catch (Exception e) {
            Base.getLogger(this).error("Error while converting value: " + String.valueOf(value), e);
            return new JLabel(new I18NKey("loading.error").resolvedText());
        }
    }

    protected TARGETTYPE converted(SOURCETYPE value) {
        return this.converter.convert(value);
    }

    @Override
    public String renderAsText(SOURCETYPE value) {
        return this.innerRenderer.renderAsText(this.converted(value));
    }
}

