/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.gui.data.renderer.SelectionChangeListener;
import com.schneide.base.i18n.NotI18NYet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;

public class BooleanRenderer<ELEMENT>
extends AbstractAsynchronousRenderer<Boolean> {
    private static final long serialVersionUID = 4396092922043693618L;
    private DataResult<ELEMENT, Boolean> dataResult;
    private JCheckBox editor;
    private final SelectionChangeListener<ELEMENT> listener;

    public BooleanRenderer(SelectionChangeListener<ELEMENT> initialListener) {
        this.listener = initialListener;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.dataResult = (DataResult)value;
        this.fireEditingStopped();
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    protected JComponent getComponentFor(Boolean value) {
        this.editor = new JCheckBox();
        this.editor.setSelected(value);
        this.editor.setOpaque(true);
        this.editor.addActionListener(e -> {
            if (null == this.listener) {
                return;
            }
            ELEMENT currentElement = this.dataResult.getElement();
            this.listener.userChangedValueFor(currentElement, -1, this.editor.isSelected());
        });
        return this.editor;
    }

    public Dimension getPreferredSize() {
        return new JCheckBox().getPreferredSize();
    }

    @Override
    public String renderAsText(Boolean value) {
        if (value.booleanValue()) {
            return new NotI18NYet("ja", new Object[0]).text();
        }
        return new NotI18NYet("nein", new Object[0]).text();
    }
}

