/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.renderer;

import com.schneide.base.gui.component.AbstractTableCellEditorRenderer;
import com.schneide.base.gui.component.CellRendererLabel;
import com.schneide.base.gui.component.table.TableColorProviderFactory;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.system.Base;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class AbstractAsynchronousRenderer<VALUE>
extends AbstractTableCellEditorRenderer<JComponent, DataResult<?, VALUE>> {
    private static final long serialVersionUID = -795365185316217091L;
    private final I18NResolvable loadingText;

    protected AbstractAsynchronousRenderer() {
        this(new I18NKey("loading"));
    }

    protected AbstractAsynchronousRenderer(I18NResolvable loadingText) {
        this.loadingText = loadingText;
    }

    protected AbstractAsynchronousRenderer(TableColorProviderFactory<DataResult<?, VALUE>> newFactory) {
        this(new I18NKey("loading"), newFactory);
    }

    protected AbstractAsynchronousRenderer(I18NResolvable loadingText, TableColorProviderFactory<DataResult<?, VALUE>> newFactory) {
        super(newFactory);
        this.loadingText = loadingText;
    }

    @Override
    protected final JComponent getComponent(DataResult<?, VALUE> result) {
        if (!result.hasLoaded()) {
            result.execute();
            return new CellRendererLabel(this.loadingText.resolvedText());
        }
        try {
            return this.getComponentFor(result.getValue());
        }
        catch (Exception e) {
            Base.getLogger(this).error("Error while getting value", e);
            return new JLabel(new I18NKey("loading.error").resolvedText());
        }
    }

    protected abstract JComponent getComponentFor(VALUE var1);

    public abstract String renderAsText(VALUE var1);
}

