/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.system.Base;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class TableDoubleClickListener
extends MouseAdapter {
    private final List<TableColumnBinding> columnBindings;
    private final List<IRowDoubleClickListener> listeners;

    public TableDoubleClickListener(List<TableColumnBinding> columnBindings) {
        this.columnBindings = columnBindings;
        this.listeners = new ArrayList<IRowDoubleClickListener>();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isDoubleClick(e)) {
            return;
        }
        JTable table = this.getTable(e);
        int row = table.getRowSorter().convertRowIndexToModel(table.rowAtPoint(e.getPoint()));
        this.notifyRowDoubleClickListener(row);
        int column = table.columnAtPoint(e.getPoint());
        this.notifyColumnBinding(this.columnBindings.get(column), (DataResult)table.getModel().getValueAt(row, column));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowListener(IRowDoubleClickListener l) {
        List<IRowDoubleClickListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowListener(IRowDoubleClickListener l) {
        List<IRowDoubleClickListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowDoubleClickListener[] getListeners() {
        List<IRowDoubleClickListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new IRowDoubleClickListener[this.listeners.size()]);
        }
    }

    private void notifyRowDoubleClickListener(int row) {
        for (IRowDoubleClickListener listener : this.getListeners()) {
            listener.rowDoubleClicked(row);
        }
    }

    private <E, V> void notifyColumnBinding(TableColumnBinding<E, V> binding, DataResult<E, V> value) {
        try {
            binding.cellDoubleClicked(value.getElement(), value.getValue());
        }
        catch (Exception e) {
            Base.getLogger(this).error("Error while notifying column binding of double click", e);
        }
    }

    private JTable getTable(MouseEvent e) {
        return (JTable)e.getSource();
    }

    private boolean isDoubleClick(MouseEvent e) {
        return 2 == e.getClickCount();
    }

    public static interface IRowDoubleClickListener {
        public void rowDoubleClicked(int var1);
    }
}

