/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.gui.data.bindings.BindingTableModel;
import com.schneide.base.gui.data.bindings.BindingTableRowSorter;
import com.schneide.base.gui.data.bindings.SelectionListener;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.gui.data.bindings.TableDoubleClickListener;
import com.schneide.base.gui.data.bindings.TableKeyListener;
import com.schneide.base.gui.data.value.ListValue;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.lifecycle.ComponentLifeCycle;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.ParentLifeCycle;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class TableColumnBinder<DATA> {
    private final List<TableColumnBinding<DATA, ?>> bindings = new ArrayList();
    private TableDoubleClickListener doubleClickListener;
    private final Map<JButton, SelectableDecider<DATA>> selectableDeciders = new HashMap<JButton, SelectableDecider<DATA>>();

    public void addColumnBinding(TableColumnBinding<DATA, ?> binding) {
        this.addColumnBinding(this.bindings.size(), binding);
    }

    public void addColumnBinding(int index, TableColumnBinding<DATA, ?> binding) {
        if (null == binding) {
            return;
        }
        this.bindings.add(index, binding);
    }

    public Iterable<TableColumnBinding<DATA, ?>> getColumnBindingIterable() {
        return this.bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectableDecider(JButton button, SelectableDecider<DATA> decider) {
        Map<JButton, SelectableDecider<DATA>> map = this.selectableDeciders;
        synchronized (map) {
            this.selectableDeciders.put(button, decider);
        }
    }

    public void bindTo(JTable table, ListValue<DATA> listValue) {
        this.bindTo(table, listValue, new ComponentLifeCycle<JTable>(table));
    }

    public void bindTo(JTable table, final ListValue<DATA> listValue, ParentLifeCycle parentLifeCycle) {
        final BindingTableModel<DATA> bindingTableModel = new BindingTableModel<DATA>(listValue, this.getColumnBindingIterable());
        table.setModel(bindingTableModel);
        int columnIndex = 0;
        ArrayList<TableColumnBinding> bindingListCopy = new ArrayList<TableColumnBinding>();
        for (TableColumnBinding<DATA, ?> binding : this.getColumnBindingIterable()) {
            binding.addChangeListener(bindingTableModel);
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            column.setCellRenderer(binding.getColumnRenderer());
            if (binding.isEditable()) {
                column.setCellEditor(binding.getColumnEditor());
            }
            column.setPreferredWidth(binding.getPreferredWidth());
            column.setMaxWidth(binding.getMaxWidth());
            ++columnIndex;
            bindingListCopy.add(binding);
        }
        BindingTableRowSorter<DATA> sorter = new BindingTableRowSorter<DATA>(bindingTableModel, bindingListCopy);
        table.setRowSorter(sorter);
        this.doubleClickListener = new TableDoubleClickListener(bindingListCopy);
        table.addMouseListener(this.doubleClickListener);
        table.addKeyListener(new TableKeyListener());
        parentLifeCycle.setChildLifeCycle(new LifeCycle(){

            @Override
            public void start() {
                listValue.init();
                listValue.addListChangeListener(bindingTableModel);
            }

            @Override
            public void stop() {
                listValue.removeListChangeListener(bindingTableModel);
                listValue.dispose();
            }
        });
        parentLifeCycle.start();
    }

    public void setInitialSortOrder(JTable table, int column, SortOrder sortOrder) {
        BindingTableRowSorter sorter = (BindingTableRowSorter)table.getRowSorter();
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(column, sortOrder)));
        sorter.sort();
    }

    public void addSelectionListenerTo(JTable table, ListValue<DATA> listValue, SelectionListener<DATA> l) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionAdapter<DATA>(table, listValue, l));
    }

    public void removeSelectionListenerTo(JTable table, ListValue<DATA> listValue, SelectionListener<DATA> l) {
        table.getSelectionModel().removeListSelectionListener(new ListSelectionAdapter<DATA>(table, listValue, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSelectable(JButton button, DATA element, int index) {
        Map<JButton, SelectableDecider<DATA>> map = this.selectableDeciders;
        synchronized (map) {
            if (this.selectableDeciders.containsKey(button)) {
                return this.selectableDeciders.get(button).isSelectable(element, index);
            }
        }
        return true;
    }

    public void addSelectionAwareButtons(final JTable table, final ListValue<DATA> listValue, final JButton ... buttons) {
        for (JButton button : buttons) {
            button.setEnabled(false);
        }
        final SelectionListener selectionListener = new SelectionListener<DATA>(){

            @Override
            public void elementSelected(DATA element, int index) {
                for (JButton button : buttons) {
                    button.setEnabled(TableColumnBinder.this.isSelectable(button, element, index));
                }
            }

            @Override
            public void noneSelected() {
                for (JButton button : buttons) {
                    button.setEnabled(false);
                }
            }
        };
        ComponentLifeCycle<JTable> tableLifeCycle = new ComponentLifeCycle<JTable>(table);
        tableLifeCycle.setChildLifeCycle(new LifeCycle(){

            @Override
            public void start() {
                TableColumnBinder.this.addSelectionListenerTo(table, listValue, selectionListener);
            }

            @Override
            public void stop() {
                TableColumnBinder.this.removeSelectionListenerTo(table, listValue, selectionListener);
            }
        });
        tableLifeCycle.start();
    }

    public TableDoubleClickListener getDoubleClickListener() {
        if (null == this.doubleClickListener) {
            throw new IllegalStateException("Method \"bindTo\" must be called prior to \"getDoubleClickListener\"");
        }
        return this.doubleClickListener;
    }

    private static final class ListSelectionAdapter<DATA>
    implements ListSelectionListener,
    EqualsBuilder.EqualComparable {
        private final SelectionListener<DATA> selectionListener;
        private final ListValue<DATA> listValue;
        private final JTable table;

        public ListSelectionAdapter(JTable table, ListValue<DATA> listValue, SelectionListener<DATA> selectionListener) {
            this.table = table;
            this.listValue = listValue;
            this.selectionListener = selectionListener;
        }

        public Iterable<Object> getValuesToCompare() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.table);
            result.add(this.selectionListener);
            result.add(this.listValue);
            return result;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.isEqual(this, obj);
        }

        public int hashCode() {
            return EqualsBuilder.hashCodeFor(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            EDT.perform(() -> {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                if (model.isSelectionEmpty()) {
                    this.selectionListener.noneSelected();
                    return;
                }
                int row = this.table.getRowSorter().convertRowIndexToModel(model.getMinSelectionIndex());
                this.selectionListener.elementSelected(this.listValue.getElementAt(row), row);
            });
        }
    }

    public static interface SelectableDecider<DATA> {
        public boolean isSelectable(DATA var1, int var2);
    }
}

