/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.gui.data.bindings.AbstractFailureHandlingTableColumnBinding;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.gui.data.renderer.DateTimeRenderer;
import com.schneide.base.i18n.model.I18NResolvable;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class DateTimeColumnBinding<E>
extends AbstractFailureHandlingTableColumnBinding<E, DateTime> {
    public DateTimeColumnBinding(String name) {
        super(name);
    }

    public DateTimeColumnBinding(String name, boolean isLongRunning) {
        super(name, isLongRunning);
    }

    public DateTimeColumnBinding(String name, I18NResolvable invalidValueText) {
        super(name, invalidValueText);
    }

    public DateTimeColumnBinding(String name, boolean isLongRunning, I18NResolvable invalidValueText) {
        super(name, isLongRunning, invalidValueText);
    }

    protected boolean isValidValue(DateTime dateTime) {
        return null != dateTime && dateTime.isAfter(0L);
    }

    @Override
    public AbstractAsynchronousRenderer<DateTime> getColumnRenderer() {
        return new DateTimeRenderer(this.getDateFormatter(), this.getInvalidValueText());
    }

    protected DateTimeFormatter getDateFormatter() {
        return DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm");
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    protected Comparator<DateTime> getComparatorFor() {
        DateTimeComparator comparator = DateTimeComparator.getInstance();
        return (o1, o2) -> comparator.compare(o1, o2);
    }
}

