/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.data.bindings;

import com.schneide.base.gui.data.bindings.ColumnValueChangeListener;
import com.schneide.base.gui.data.bindings.DataResult;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.gui.data.renderer.AbstractAsynchronousRenderer;
import com.schneide.base.gui.data.renderer.DefaultRenderer;
import com.schneide.base.logging.LoggedObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractTableColumnBinding<ELEMENT, VALUE>
extends LoggedObject
implements TableColumnBinding<ELEMENT, VALUE> {
    protected static final int DEFAULT_PREFERRED_WIDTH = 100;
    protected static final int DEFAULT_MAX_WIDTH = 1000;
    protected static final boolean DEFAULT_LONG_RUNNING = false;
    private final List<ColumnValueChangeListener<ELEMENT>> listeners;
    private final String name;
    private final boolean isLongRunning;

    protected AbstractTableColumnBinding(String name) {
        this(name, false);
    }

    protected AbstractTableColumnBinding(String name, boolean isLongRunning) {
        this.name = name;
        this.isLongRunning = isLongRunning;
        this.listeners = new ArrayList<ColumnValueChangeListener<ELEMENT>>();
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void cellDoubleClicked(ELEMENT element, VALUE value) {
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public final Comparator<DataResult<ELEMENT, VALUE>> getComparator() {
        return (o1, o2) -> {
            if (o1.hasLoaded() && o2.hasLoaded()) {
                try {
                    return this.getComparatorFor().compare(o1.getValue(), o2.getValue());
                }
                catch (Exception e) {
                    this.getLogger().warn("Error while comparing two data results", e);
                }
            }
            return new DataResultLoadingStateComparator().compare((DataResult<?, ?>)o1, (DataResult<?, ?>)o2);
        };
    }

    protected Comparator<VALUE> getComparatorFor() {
        return null;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public boolean isLongRunning() {
        return this.isLongRunning;
    }

    @Override
    public int getPreferredWidth() {
        return 100;
    }

    @Override
    public int getMaxWidth() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnValueChangeListener<ELEMENT>[] getListeners() {
        List<ColumnValueChangeListener<ELEMENT>> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new ColumnValueChangeListener[this.listeners.size()]);
        }
    }

    protected void fireColumnValueChangedFor(ELEMENT element) {
        for (ColumnValueChangeListener<ELEMENT> l : this.getListeners()) {
            l.columnValueChanged(this, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addChangeListener(ColumnValueChangeListener<ELEMENT> l) {
        List<ColumnValueChangeListener<ELEMENT>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    @Override
    public AbstractAsynchronousRenderer<VALUE> getColumnRenderer() {
        return new DefaultRenderer();
    }

    @Override
    public AbstractAsynchronousRenderer<VALUE> getColumnEditor() {
        return this.getColumnRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeChangeListener(ColumnValueChangeListener<ELEMENT> l) {
        List<ColumnValueChangeListener<ELEMENT>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    private static final class DataResultLoadingStateComparator
    implements Comparator<DataResult<?, ?>>,
    Serializable {
        private static final long serialVersionUID = -7794316506443290252L;

        @Override
        public int compare(DataResult<?, ?> o1, DataResult<?, ?> o2) {
            if (!o1.hasLoaded()) {
                if (o2.hasLoaded()) {
                    return -1;
                }
                return 0;
            }
            if (o2.hasLoaded()) {
                return 0;
            }
            return 1;
        }
    }
}

