/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component.table;

import com.schneide.base.gui.component.table.NormalColorProvider;
import com.schneide.base.gui.component.table.TableCellRendererColorProvider;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.UIManager;

class EditableColorProvider
implements TableCellRendererColorProvider {
    private final JTable table;
    private final boolean isAlternateRow;
    private final Color alternateColor;

    public EditableColorProvider(JTable table, Color alternateColor, boolean isAlternateRow) {
        this.table = table;
        this.alternateColor = alternateColor;
        this.isAlternateRow = isAlternateRow;
    }

    @Override
    public Color getBackground() {
        if (!this.isColorSet("Table.focusCellBackground")) {
            return new NormalColorProvider(this.table, this.alternateColor, this.isAlternateRow).getBackground();
        }
        if (this.isAlternateRow) {
            return this.alternateColor;
        }
        return UIManager.getColor("Table.focusCellBackground");
    }

    @Override
    public Color getForeground() {
        if (!this.isColorSet("Table.focusCellForeground")) {
            return new NormalColorProvider(this.table, this.alternateColor, this.isAlternateRow).getForeground();
        }
        return UIManager.getColor("Table.focusCellForeground");
    }

    private boolean isColorSet(String propertyName) {
        return null != UIManager.getColor(propertyName);
    }
}

