/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component.generic;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.LoggedObject;
import java.awt.Component;
import java.awt.Window;

public abstract class UIWidget<C extends Component>
extends LoggedObject {
    private boolean isUIBuilt;
    private final C component;

    protected UIWidget(C component) {
        EDT.only();
        this.component = component;
        this.isUIBuilt = false;
    }

    public final void show() {
        EDT.performBlocking(() -> {
            if (!this.isUIBuilt()) {
                this.buildUI();
            }
            this.setUIBuilt();
            ((Component)this.getComponent()).setVisible(true);
        });
    }

    protected boolean isUIBuilt() {
        return this.isUIBuilt;
    }

    protected void setUIBuilt() {
        this.isUIBuilt = true;
    }

    public final C getComponent() {
        return this.component;
    }

    protected final void buildUI() {
        EDT.only();
        NeedsPack processFurther = this.buildWidget();
        if (NeedsPack.NO == processFurther) {
            return;
        }
        if (this.component instanceof Window) {
            ((Window)this.component).pack();
        }
    }

    protected abstract NeedsPack buildWidget();

    public final void hide() {
        EDT.perform(() -> ((Component)this.getComponent()).setVisible(false));
    }

    protected static enum NeedsPack {
        YES,
        NO;

    }
}

