/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component.generic;

import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.LoggedObject;
import javax.swing.JComponent;

public abstract class UIComponent<W extends JComponent>
extends LoggedObject {
    private boolean isUIBuilt;
    private W component;

    protected UIComponent() {
        EDT.whatever();
        this.isUIBuilt = false;
        this.component = null;
    }

    protected void setupUI() {
    }

    protected boolean isBuilt() {
        return this.isUIBuilt;
    }

    public final W prepare() {
        EDT.whatever();
        this.prepareUI();
        return this.getComponent();
    }

    protected final void prepareUI() {
        EDT.whatever();
        if (this.isUIBuilt) {
            return;
        }
        EDT.performBlocking(() -> {
            this.setupUI();
            this.buildUI();
        });
        this.isUIBuilt = true;
    }

    protected final W getComponent() {
        return this.component;
    }

    protected final void buildUI() {
        EDT.only();
        this.component = this.buildComponent();
        this.setupComponent();
    }

    protected abstract W buildComponent();

    protected void setupComponent() {
    }

    public void show() {
        EDT.performBlocking(() -> {
            this.prepareUI();
            ((JComponent)this.getComponent()).setVisible(true);
        });
    }

    public final void hide() {
        EDT.perform(() -> ((JComponent)this.getComponent()).setVisible(false));
    }
}

