/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class StateLabel
extends JLabel {
    private static final long serialVersionUID = -3910225997496493287L;
    private static final String GREEN_LIGHT_FILEPATH = "resources/images/icons/light_green16.png";
    private static final String RED_LIGHT_FILEPATH = "resources/images/icons/light_red16.png";
    private static final String GRAY_LIGHT_FILEPATH = "resources/images/icons/light_gray16.png";
    private final Map<Object, PicturedState> statePictureMap = new HashMap<Object, PicturedState>();
    private Object currentState;

    public static StateLabel buildBooleanStateLabel(String title, boolean currentState) {
        return new StateLabel(title, currentState, new SystemResourceBasedState(Boolean.TRUE, GREEN_LIGHT_FILEPATH), new SystemResourceBasedState(Boolean.FALSE, RED_LIGHT_FILEPATH));
    }

    public static StateLabel forTriState(String title, Boolean currentState) {
        return new StateLabel(title, currentState, new SystemResourceBasedState(Boolean.TRUE, GREEN_LIGHT_FILEPATH), new SystemResourceBasedState(Boolean.FALSE, RED_LIGHT_FILEPATH), new SystemResourceBasedState(null, GRAY_LIGHT_FILEPATH));
    }

    public StateLabel(String title, Object currentState, PicturedState ... states) {
        super(title);
        for (PicturedState state : states) {
            this.statePictureMap.put(state.getIdentifier(), state);
        }
        this.setState(currentState);
    }

    public void setState(Object stateIdentifier) throws IllegalArgumentException {
        this.currentState = stateIdentifier;
        PicturedState picturedState = this.statePictureMap.get(stateIdentifier);
        if (null != picturedState) {
            this.setIcon(picturedState.getPicture());
            this.repaint();
        }
    }

    public Object getState() {
        return this.currentState;
    }

    public static interface PicturedState {
        public Object getIdentifier();

        public Icon getPicture();
    }

    private static class SystemResourceBasedState
    implements PicturedState {
        private final Object stateIdentifier;
        private final String resourcePath;

        public SystemResourceBasedState(Object stateIdentifier, String resourcePath) {
            this.stateIdentifier = stateIdentifier;
            this.resourcePath = resourcePath;
        }

        @Override
        public Object getIdentifier() {
            return this.stateIdentifier;
        }

        @Override
        public Icon getPicture() {
            return new ImageIcon(ClassLoader.getSystemResource(this.resourcePath));
        }
    }
}

