/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component;

import com.schneide.base.gui.component.SchneideTableResourceProvider;
import com.schneide.base.gui.component.SortableTableModel;
import com.schneide.base.io.file.FileLocator;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SchneideTable
extends JTable {
    private static final long serialVersionUID = -829520042010870298L;
    private final SchneideTableResourceProvider resourceProvider;

    public SchneideTable(TableModel tableModel) {
        this(tableModel, new DefaultSchneideTableResourceProvider());
    }

    public SchneideTable(TableModel tableModel, SchneideTableResourceProvider resourceProvider) {
        super(tableModel);
        this.resourceProvider = resourceProvider;
        this.makeTableSortable();
    }

    private void makeTableSortable() {
        JTableHeader header = this.getTableHeader();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumn(this.getColumnName(i));
            column.setHeaderRenderer(new DefaultTableHeaderRenderer());
        }
        header.setUpdateTableInRealTime(true);
        header.addMouseListener(new ColumnListener());
        header.setReorderingAllowed(true);
    }

    public int getSelectedIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel sm = this.getSelectionModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!sm.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getAutoResizeMode() == 0) {
            return false;
        }
        Container p = this.getParent();
        if (p instanceof JViewport) {
            return this.getAutoResizeMode() != 4 || !(p.getSize().getWidth() < this.getPreferredSize().getWidth());
        }
        return false;
    }

    private SchneideTableResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    private static class DefaultSchneideTableResourceProvider
    implements SchneideTableResourceProvider {
        private final ImageIcon sortAscendIcon;
        private final ImageIcon sortDescendIcon;

        public DefaultSchneideTableResourceProvider() {
            File imageFile = FileLocator.getFile("resources/images/icons/search_desc.gif");
            this.sortDescendIcon = new ImageIcon(imageFile.getAbsolutePath());
            imageFile = FileLocator.getFile("resources/images/icons/search_asc.gif");
            this.sortAscendIcon = new ImageIcon(imageFile.getAbsolutePath());
        }

        @Override
        public ImageIcon getSortDescendImageFile() {
            return this.sortDescendIcon;
        }

        @Override
        public ImageIcon getSortAscendImageFile() {
            return this.sortAscendIcon;
        }
    }

    private static class DefaultTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4044025829399274883L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(this.getValueRepresentation(value));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        private String getValueRepresentation(Object value) {
            if (null == value) {
                return "";
            }
            return String.valueOf(value);
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private int sortedColumn = -1;
        private boolean sortAscend = true;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.isSortableTable()) {
                return;
            }
            int columnModelIndex = SchneideTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            int modelIndex = SchneideTable.this.getColumnModel().getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            this.changeSortState(modelIndex);
            this.adjustTableHeader();
            SchneideTable.this.getTableHeader().repaint();
            this.performSorting();
        }

        private void performSorting() {
            TableModel model = SchneideTable.this.getModel();
            if (model instanceof SortableTableModel) {
                SortableTableModel sortableTableModel = (SortableTableModel)((Object)model);
                sortableTableModel.sortColumn(this.sortedColumn, this.sortAscend);
            }
        }

        private void adjustTableHeader() {
            for (int i = 0; i < SchneideTable.this.getColumnCount(); ++i) {
                TableColumn column = SchneideTable.this.getColumnModel().getColumn(i);
                int index = column.getModelIndex();
                TableCellRenderer tableCellRenderer = column.getHeaderRenderer();
                if (!(tableCellRenderer instanceof JLabel)) continue;
                JLabel headerLabel = (JLabel)((Object)tableCellRenderer);
                headerLabel.setIcon(this.getColumnIcon(index));
            }
        }

        private void changeSortState(int modelIndex) {
            if (this.sortedColumn == modelIndex) {
                this.sortAscend = !this.sortAscend;
            } else {
                this.sortedColumn = modelIndex;
                this.sortAscend = true;
            }
        }

        private boolean isSortableTable() {
            return SchneideTable.this.getModel() instanceof SortableTableModel;
        }

        private Icon getColumnIcon(int columnIndex) {
            if (columnIndex == this.sortedColumn) {
                if (this.sortAscend) {
                    return SchneideTable.this.getResourceProvider().getSortAscendImageFile();
                }
                return SchneideTable.this.getResourceProvider().getSortDescendImageFile();
            }
            return null;
        }
    }
}

