/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component;

import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.HTMLText;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class Legend
extends LoggedObject {
    private final String title;
    private final List<LegendEntry> entries;

    protected Legend(String title) {
        EDT.whatever();
        this.title = title;
        this.entries = new ArrayList<LegendEntry>();
    }

    protected abstract LayoutManager getLayoutManager();

    public void addEntry(IconProvider icon, String description) {
        this.addEntry(icon, description, description);
    }

    public void addEntry(IconProvider icon, String description, String tooltip) {
        this.entries.add(new LegendEntry(icon, description, tooltip));
    }

    public List<LegendEntry> getEntries() {
        return this.entries;
    }

    public String getTitle() {
        return this.title;
    }

    public JComponent buildComponent() {
        return EDT.query(() -> {
            JPanel result = new JPanel(this.getLayoutManager());
            JLabel titleLabel = new JLabel(HTMLText.bold(this.getTitle()).buildHTML());
            result.add(titleLabel);
            result.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            for (LegendEntry entry : this.getEntries()) {
                result.add(entry.buildEntry());
            }
            result.setOpaque(false);
            return result;
        });
    }

    protected static class LegendEntry {
        private final IconProvider icon;
        private final String description;
        private final String tooltip;

        protected LegendEntry(IconProvider icon, String description, String tooltip) {
            this.icon = icon;
            this.description = description;
            this.tooltip = tooltip;
        }

        protected JComponent buildEntry() {
            EDT.always();
            JPanel result = new JPanel();
            result.add(new JLabel(this.icon.icon()));
            result.add(new JLabel(this.description));
            result.setToolTipText(this.tooltip);
            result.setOpaque(false);
            return result;
        }
    }
}

