/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.component;

import com.schneide.base.text.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class IndentedTitledBorder
extends TitledBorder {
    private static final long serialVersionUID = -7401438916622296033L;
    protected static final int TEXT_INSET_HORIZONTAL = 0;

    public IndentedTitledBorder(String title) {
        this(title, 15);
    }

    public IndentedTitledBorder(String title, int indentation) {
        super(new EmptyBorder(0, indentation, 0, 0), title);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (Text.isEmpty(this.getTitle())) {
            this.getBorder().paintBorder(c, g, x, y, width, height);
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle());
        Insets insets = this.border.getBorderInsets(c);
        int titlePos = this.getTitlePosition();
        Point textLoc = new Point();
        textLoc.y = this.calculateTextLocationY(grooveRect, fontHeight, descent, ascent, insets, titlePos);
        int justification = this.getTitleJustification();
        textLoc.x = this.calculateTextLocationX(grooveRect, stringWidth, justification);
        this.getBorder().paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), textLoc.x, textLoc.y);
        g.setFont(font);
        g.setColor(color);
    }

    private int calculateTextLocationY(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets, int titlePos) {
        IndentedTitleBorderLocationY yLocation = IndentedTitleBorderLocationY.getLocationFor(titlePos);
        return yLocation.calculateTextLocation(grooveRect, fontHeight, descent, ascent, insets);
    }

    private int calculateTextLocationX(Rectangle grooveRect, int stringWidth, int justification) {
        IndentedTitleBorderLocationX xLocation = IndentedTitleBorderLocationX.getLocationFor(justification);
        return xLocation.calculateTextLocation(grooveRect, stringWidth);
    }

    protected static enum IndentedTitleBorderLocationY {
        DEFAULT_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                return TOP_VALIGN.calculateTextLocation(grooveRect, fontHeight, descent, ascent, insets);
            }
        }
        ,
        ABOVE_TOP_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                return grooveRect.y - (descent + 2);
            }
        }
        ,
        TOP_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                return grooveRect.y - descent + (insets.top + ascent + descent) / 2;
            }
        }
        ,
        BELOW_TOP_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                return grooveRect.y + insets.top + ascent + 2;
            }
        }
        ,
        ABOVE_BOTTOM_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                return grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
            }
        }
        ,
        BOTTOM_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                grooveRect.height -= fontHeight / 2;
                return grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
            }
        }
        ,
        BELOW_BOTTOM_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                grooveRect.height -= fontHeight;
                return grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        ,
        UNKNOWN_VALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int fontHeight, int descent, int ascent, Insets insets) {
                return 0;
            }
        };


        public abstract int calculateTextLocation(Rectangle var1, int var2, int var3, int var4, Insets var5);

        public static boolean isValidAlignment(int justification) {
            return 0 <= justification && IndentedTitleBorderLocationY.values().length > justification;
        }

        public static IndentedTitleBorderLocationY getLocationFor(int titlePosition) {
            if (IndentedTitleBorderLocationY.isValidAlignment(titlePosition)) {
                return IndentedTitleBorderLocationY.values()[titlePosition];
            }
            return UNKNOWN_VALIGN;
        }
    }

    protected static enum IndentedTitleBorderLocationX {
        DEFAULT_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                return LEADING_ALIGN.calculateTextLocation(grooveRect, stringWidth);
            }
        }
        ,
        LEFT_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                return grooveRect.x + 0;
            }
        }
        ,
        CENTER_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                return grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        ,
        RIGHT_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                return grooveRect.x + grooveRect.width - (stringWidth + 0);
            }
        }
        ,
        LEADING_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                if (isLeftToRight) {
                    return LEFT_ALIGN.calculateTextLocation(grooveRect, stringWidth);
                }
                return RIGHT_ALIGN.calculateTextLocation(grooveRect, stringWidth);
            }
        }
        ,
        TRAILING_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                if (isLeftToRight) {
                    return RIGHT_ALIGN.calculateTextLocation(grooveRect, stringWidth);
                }
                return LEFT_ALIGN.calculateTextLocation(grooveRect, stringWidth);
            }
        }
        ,
        UNKOWN_ALIGN{

            @Override
            public int calculateTextLocation(Rectangle grooveRect, int stringWidth) {
                return 0;
            }
        };

        private static boolean isLeftToRight;

        public abstract int calculateTextLocation(Rectangle var1, int var2);

        public static boolean isValidAlignment(int justification) {
            return 0 <= justification && IndentedTitleBorderLocationX.values().length > justification;
        }

        public static IndentedTitleBorderLocationX getLocationFor(int justification) {
            if (IndentedTitleBorderLocationX.isValidAlignment(justification)) {
                return IndentedTitleBorderLocationX.values()[justification];
            }
            return UNKOWN_ALIGN;
        }

        public static void setIsLeftToRight(boolean leftToRight) {
            isLeftToRight = leftToRight;
        }

        static {
            isLeftToRight = true;
        }
    }
}

