/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import com.schneide.base.maths.Percent;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public final class Resize {
    private Resize() {
    }

    public static ResizeFrame frame(Frame frame) {
        return new ResizeFrame(frame);
    }

    public static class ResizeFrame
    extends ResizeWindow<ResizeFrame> {
        private final Frame frame;

        public ResizeFrame(Frame frame) {
            super(frame);
            this.frame = frame;
        }

        @Override
        protected ResizeFrame getReturnType() {
            return this;
        }

        public ResizeFrame maximize() {
            this.frame.setExtendedState(6);
            return this;
        }

        public ResizeFrame minimize() {
            this.frame.setExtendedState(1);
            return this;
        }
    }

    public static abstract class ResizeWindow<T extends ResizeWindow<?>> {
        private final Window window;

        protected ResizeWindow(Window window) {
            this.window = window;
        }

        protected Window window() {
            return this.window;
        }

        protected abstract T getReturnType();

        protected Rectangle getMaximumDesktopArea() {
            Dimension screenSize = this.window().getToolkit().getScreenSize();
            Insets screenInsets = this.window().getToolkit().getScreenInsets(this.window().getGraphicsConfiguration());
            Rectangle result = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - (screenInsets.left + screenInsets.right), screenSize.height - (screenInsets.bottom + screenInsets.top));
            return result;
        }

        protected int getFromScreenWidth(Percent percent) {
            return this.getFrom(this.getMaximumDesktopArea().getWidth(), percent);
        }

        protected int getFromScreenHeight(Percent percent) {
            return this.getFrom(this.getMaximumDesktopArea().getHeight(), percent);
        }

        protected int getFrom(double axisLength, Percent percent) {
            return (int)(axisLength * percent.getAsFactor());
        }

        public T to(Dimension windowSize) {
            this.window().setSize(windowSize);
            return this.getReturnType();
        }

        public T to(int width, int height) {
            return this.to(new Dimension(width, height));
        }

        public T at(Point location) {
            this.window().setLocation(location);
            return this.getReturnType();
        }

        public T horizontally(Percent percent) {
            this.window().setSize(this.getFromScreenWidth(percent), this.window().getHeight());
            return this.getReturnType();
        }

        public T vertically(Percent percent) {
            this.window().setSize(this.window().getWidth(), this.getFromScreenHeight(percent));
            return this.getReturnType();
        }
    }
}

