/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageLabel
extends JComponent {
    private static final long serialVersionUID = -5862956548285146141L;
    private Image image;
    private int imageWidth;
    private int imageHeight;

    public ImageLabel(BufferedImage image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public ImageLabel(ImageIcon image) {
        this(image.getImage(), image.getIconWidth(), image.getIconHeight());
    }

    public ImageLabel(Image image, int imageWidth, int imageHeight) {
        this.image = image;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension labelSize = this.getSize();
            int xOffset = (labelSize.width - this.imageWidth) / 2;
            int yOffset = (labelSize.height - this.imageHeight) / 2;
            g2d.drawImage(this.image, xOffset, yOffset, this);
        }
        super.paint(g);
    }
}

