/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import com.schneide.base.datatypes.ObjectStack;
import com.schneide.base.general.AbstractIdentifiedObject;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.util.Parameter;
import java.awt.Frame;
import java.awt.Window;
import java.util.EmptyStackException;

public class GenericWindowStack
extends AbstractIdentifiedObject
implements WindowStack {
    private final ObjectStack windowStack = new ObjectStack();
    private Frame mainFrame;

    public GenericWindowStack(String identifier, Window ... windows) {
        super(identifier);
        for (Window window : windows) {
            this.windowStack.push(window);
        }
    }

    @Override
    public final Window getActiveWindow() {
        try {
            return (Window)this.windowStack.peek();
        }
        catch (EmptyStackException e) {
            Parameter.isPresent(e);
            return this.getAbstractMainFrame();
        }
    }

    @Override
    public final boolean hasMainFrame() {
        return null != this.getAbstractMainFrame();
    }

    @Override
    public final Frame getAbstractMainFrame() {
        return this.mainFrame;
    }

    public final ObjectStack getWindowStack() {
        return this.windowStack;
    }

    public final void setAbstractMainFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public static WindowStack getParentlessWindowStack() {
        return new WindowStack(){

            @Override
            public String getIdentifier() {
                return "TestStack";
            }

            @Override
            public Window getActiveWindow() {
                return null;
            }

            @Override
            public boolean hasMainFrame() {
                return false;
            }

            @Override
            public Frame getAbstractMainFrame() {
                return null;
            }
        };
    }
}

