/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import com.schneide.base.gui.ScreenLayouter;
import com.schneide.base.gui.model.WindowStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public final class GUITools {
    private GUITools() {
    }

    public static Point calculateWindowStackLocation(WindowStack windowStack, Window window) {
        Point baseFrameCenter = GUITools.getBaseFrameCenter(windowStack);
        Point upperLeftCorner = new Point(baseFrameCenter.x - window.getWidth() / 2, baseFrameCenter.y - window.getHeight() / 2);
        return GUITools.adjustToVisibleArea(upperLeftCorner);
    }

    public static Point calculateScreenLocation(Window window) {
        return GUITools.calculateWindowStackLocation(null, window);
    }

    private static Point adjustToVisibleArea(Point upperLeftCorner) {
        upperLeftCorner.x = Math.max(upperLeftCorner.x, 0);
        upperLeftCorner.y = Math.max(upperLeftCorner.y, 0);
        return upperLeftCorner;
    }

    private static Point getBaseFrameCenter(WindowStack windowStack) {
        Rectangle baseFrameBounds = GUITools.getBaseFrameBounds(windowStack);
        return new Point((int)baseFrameBounds.getCenterX(), (int)baseFrameBounds.getCenterY());
    }

    private static Rectangle getBaseFrameBounds(WindowStack windowStack) {
        if (windowStack != null && windowStack.hasMainFrame()) {
            return windowStack.getAbstractMainFrame().getBounds();
        }
        return new ScreenLayouter().getScreenSize();
    }
}

