/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui;

import java.awt.Component;
import java.awt.Dimension;

public class ComponentLayouter {
    private final Component parent;

    public ComponentLayouter(Component parent) {
        this.parent = parent;
    }

    public void atCenteredTop(Component toLayout, int topMargin) {
        Dimension preferredSize = toLayout.getPreferredSize();
        Dimension size = this.parent.getSize();
        toLayout.setBounds(size.width / 2 - preferredSize.width / 2, topMargin, preferredSize.width, preferredSize.height);
    }

    public void fullSize(Component toLayout) {
        Dimension size = this.parent.getSize();
        toLayout.setBounds(0, 0, size.width, size.height);
    }

    public void topLeft(Component toLayout, int topMargin, int leftMargin) {
        toLayout.setLocation(leftMargin, topMargin);
    }

    public void topRight(Component toLayout, int topMargin, int rightMargin) {
        Dimension size = this.parent.getSize();
        toLayout.setLocation(size.width - rightMargin - toLayout.getWidth(), topMargin);
    }

    public void bottomLeft(Component toLayout, int bottomMargin, int leftMargin) {
        Dimension size = this.parent.getSize();
        toLayout.setLocation(leftMargin, size.height - bottomMargin - toLayout.getHeight());
    }
}

