/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.general;

import com.schneide.base.general.TickListener;
import com.schneide.base.listener.ListListenerHandler;
import com.schneide.base.maths.Percent;
import com.schneide.base.threading.ThreadMutex;

public class TickCounter {
    private final int maximalTicks;
    private final ListListenerHandler<TickListener> tickListeners;
    private final ThreadMutex tickLock;
    private int currentTicks;

    public TickCounter(int maximalTicks) {
        this.maximalTicks = maximalTicks;
        this.tickListeners = new ListListenerHandler();
        this.currentTicks = 0;
        this.tickLock = new ThreadMutex();
    }

    public TickCounter(int maximalTicks, int startTick) {
        this(maximalTicks);
        this.currentTicks = startTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTick() {
        ThreadMutex threadMutex = this.tickLock;
        synchronized (threadMutex) {
            ++this.currentTicks;
            boolean isOverflown = this.handleOverflow();
            this.notifyListenersOfTick();
            if (isOverflown) {
                this.notifyListenersOfOverflow();
            }
            return isOverflown;
        }
    }

    protected boolean handleOverflow() {
        boolean result = false;
        if (this.currentTicks >= this.maximalTicks) {
            this.currentTicks = 0;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentTicks() {
        ThreadMutex threadMutex = this.tickLock;
        synchronized (threadMutex) {
            return this.currentTicks;
        }
    }

    public int getMaximalTicks() {
        return this.maximalTicks;
    }

    public void addListener(TickListener listener) {
        this.tickListeners.addListener(listener);
    }

    protected void notifyListenersOfOverflow() {
        this.tickListeners.notifyListeners(listener -> listener.newOverflow(this));
    }

    protected void notifyListenersOfTick() {
        this.tickListeners.notifyListeners(listener -> listener.newTick(this));
    }

    public void removeListener(TickListener listener) {
        this.tickListeners.removeListener(listener);
    }

    public Percent getTickPercentage() {
        return Percent.createFromFactor(this.getCurrentTicks(), this.getMaximalTicks());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getCurrentTicks());
        result.append("/");
        result.append(this.getMaximalTicks());
        return result.toString();
    }
}

