/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.util;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.lifecycle.StopNotifier;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.executor.DoInBackground;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Optional;
import javax.swing.JComponent;

public class SubscriberAttaching
extends LoggedObject {
    private final Subscriber<?> target;
    private final EventBus bus;
    private Optional<SubscriberAttaching> follower;

    public SubscriberAttaching(Subscriber<?> target, EventBus bus) {
        this.target = target;
        this.bus = bus;
        this.follower = Optional.empty();
    }

    protected void unsubscribe() {
        this.target.stop();
        this.follower.ifPresent(SubscriberAttaching::unsubscribe);
    }

    public <N extends News> SubscriberAttaching untilReceiving(Class<N> unsubscribeNews) {
        this.bus.subscribe(new Unsubscriber<N>(unsubscribeNews), unsubscribeNews);
        return this;
    }

    protected EventBus bus() {
        return this.bus;
    }

    protected Subscriber<?> target() {
        return this.target;
    }

    public SubscriberAttaching whileShowing(JComponent component) {
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SubscriberAttaching.this.unsubscribe();
            }
        });
        return this;
    }

    public SubscriberAttaching andStopWith(StopNotifier notifier) {
        notifier.add(this.target);
        return this;
    }

    public SubscriberAttaching chainWith(SubscriberAttaching other) {
        SubscriberAttaching result = new SubscriberAttaching(this.target, this.bus);
        result.follower = Optional.of(other);
        return result;
    }

    private class Unsubscriber<N extends News>
    implements NewsReceiver<N> {
        private final Class<N> type;

        public Unsubscriber(Class<N> type) {
            this.type = type;
        }

        @Override
        public void receive(N news) {
            DoInBackground.now("unsubscribe " + this.type.getSimpleName(), () -> {
                SubscriberAttaching.this.bus().unsubscribe(this);
                SubscriberAttaching.this.unsubscribe();
            });
        }

        public String toString() {
            return "Unsubscriber for " + String.valueOf(SubscriberAttaching.this.target());
        }

        @Override
        public Class<N> expectedNewsType() {
            return this.type;
        }
    }
}

