/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.util;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.util.NewsProcessor;
import com.schneide.base.eventbus.util.SubscriberAttaching;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.Stoppable;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class Subscriber<N extends News>
extends LoggedObject
implements LifeCycle,
NewsReceiver<N> {
    private final List<EventBus> subscribedTo;
    private final Class<N> newsType;
    private final NewsProcessor<N> sink;
    private boolean isStarted;
    private final List<LifeCycle> dependent;

    public Subscriber(Class<N> newsType, NewsProcessor<N> sink) {
        this.newsType = newsType;
        this.sink = sink;
        this.subscribedTo = new ArrayList<EventBus>();
        this.isStarted = false;
        this.dependent = new ArrayList<LifeCycle>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTo(EventBus eventBus) {
        List<EventBus> list = this.subscribedTo;
        synchronized (list) {
            eventBus.subscribe(this, this.newsType);
            this.subscribedTo.add(eventBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeWeaklyTo(EventBus eventBus) {
        List<EventBus> list = this.subscribedTo;
        synchronized (list) {
            eventBus.subscribeWeak(this, this.newsType);
            this.subscribedTo.add(eventBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(LifeCycle lifecycled) {
        List<LifeCycle> list = this.dependent;
        synchronized (list) {
            this.dependent.add(lifecycled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() {
        List<EventBus> list = this.subscribedTo;
        synchronized (list) {
            return this.isStarted && !this.subscribedTo.isEmpty();
        }
    }

    @Override
    public void start() {
        this.isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.getLogger().debug("Stopping " + this.description());
        List<Object> list = this.subscribedTo;
        synchronized (list) {
            for (EventBus each : this.subscribedTo) {
                each.unsubscribe(this);
            }
            this.subscribedTo.clear();
        }
        list = this.dependent;
        synchronized (list) {
            this.dependent.forEach(Stoppable::stop);
        }
        this.isStarted = false;
    }

    protected String description() {
        return this.toString();
    }

    public String toString() {
        return "news subscriber for " + this.newsType.getSimpleName() + " @" + this.hashCode();
    }

    @Override
    public final void receive(N news) {
        if (!this.isStarted) {
            this.getLogger().warn("The event bus " + this.description() + " (being a " + this.getClass().getSimpleName() + ") was not started yet, but already received some news! This will not function in future versions");
        }
        this.process(news);
    }

    @Override
    public Class<N> expectedNewsType() {
        return this.newsType;
    }

    protected void process(N news) {
        this.sink.process(news);
    }

    public static <N extends News> SubscriberAttaching attach(Subscriber<N> subscriber, EventBus eventBus) {
        return Subscriber.attachInternally(subscriber, eventBus, (s, e) -> s.subscribeTo((EventBus)e));
    }

    public static <N extends News> SubscriberAttaching attachWeakly(Subscriber<N> subscriber, EventBus eventBus) {
        return Subscriber.attachInternally(subscriber, eventBus, (s, e) -> s.subscribeWeaklyTo((EventBus)e));
    }

    private static <N extends News> SubscriberAttaching attachInternally(Subscriber<N> subscriber, EventBus eventBus, BiConsumer<Subscriber<N>, EventBus> action) {
        subscriber.start();
        action.accept(subscriber, eventBus);
        return new SubscriberAttaching(subscriber, eventBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishIfSubscribed(News publication) {
        List<EventBus> list = this.subscribedTo;
        synchronized (list) {
            this.subscribedTo.forEach(bus -> bus.publish(publication));
        }
    }
}

