/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.util;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiNewsReceiver {
    private final List<HandledNews<? extends News>> handled = new ArrayList<HandledNews<? extends News>>();
    private EventBus registeredAt = null;

    public <N extends News> void handle(Class<N> type, NewsHandler<N> with) {
        HandledNews<N> newHandled = new HandledNews<N>(type, with);
        this.handled.add(newHandled);
        if (this.isAlreadySubscribed()) {
            this.register(newHandled);
        }
    }

    public void subscribeTo(EventBus eventBus) {
        if (this.isAlreadySubscribed()) {
            throw new IllegalStateException("Cannot register, because it is already registered at eventBus " + String.valueOf(this.registeredAt));
        }
        this.registeredAt = eventBus;
        for (HandledNews<? extends News> current : this.handled) {
            this.register(current);
        }
    }

    public boolean isAlreadySubscribed() {
        return null != this.registeredAt;
    }

    public void unsubscribeFromEventBus() {
        if (!this.isAlreadySubscribed()) {
            return;
        }
        for (HandledNews<? extends News> current : this.handled) {
            this.unregister(current);
        }
    }

    public <N extends News> void stopHandlingOf(Class<N> type) {
        Iterator<HandledNews<? extends News>> iterator = this.handled.iterator();
        while (iterator.hasNext()) {
            HandledNews<? extends News> current = iterator.next();
            if (!current.handles(type)) continue;
            iterator.remove();
            if (!this.isAlreadySubscribed()) continue;
            this.unregister(current);
        }
    }

    protected void unregister(HandledNews<?> current) {
        current.unregisterFrom(this.registeredAt);
    }

    protected void register(HandledNews<?> current) {
        current.registerAt(this.registeredAt);
    }

    private static class HandledNews<N extends News>
    implements NewsReceiver<N> {
        private final Class<N> type;
        private final NewsHandler<N> handler;

        public HandledNews(Class<N> type, NewsHandler<N> handler) {
            this.type = type;
            this.handler = handler;
        }

        public void registerAt(EventBus eventBus) {
            eventBus.subscribe(this, this.type);
        }

        public void unregisterFrom(EventBus eventBus) {
            eventBus.unsubscribe(this);
        }

        public boolean handles(Class<? extends News> possibleType) {
            return this.type.equals(possibleType);
        }

        @Override
        public void receive(N news) {
            this.handler.handle(news);
        }

        @Override
        public Class<N> expectedNewsType() {
            return this.type;
        }
    }

    public static interface NewsHandler<N extends News> {
        public void handle(N var1);
    }
}

