/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.util;

import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.consumer.Processor;
import java.util.function.Consumer;

public class EventBusFedConsumer<BIT extends News>
extends LoggedObject
implements LifeCycle {
    private final Processor<BIT> pending;
    private final Subscriber<BIT> receiver;
    private final Consumer<BIT> processor;

    public EventBusFedConsumer(Class<BIT> processedType, Consumer<BIT> processor, String typeDenotation, String consumerThreadName) {
        this.processor = processor;
        this.receiver = new Subscriber<News>(processedType, news -> this.schedule(news));
        this.pending = new Processor<News>(typeDenotation, consumerThreadName, bit -> this.process(bit));
    }

    protected void process(BIT next) {
        this.processor.accept(next);
    }

    protected void schedule(BIT newlyProduced) {
        this.pending.append(newlyProduced);
    }

    public void startOn(EventBus bus) {
        this.start();
        this.attachTo(bus);
    }

    public void attachTo(EventBus bus) {
        this.receiver.subscribeTo(bus);
    }

    @Override
    public void start() {
        this.pending.start();
        this.receiver.start();
    }

    @Override
    public void stop() {
        this.receiver.stop();
        this.pending.stop();
    }
}

