/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.internal.supervisor;

import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.internal.supervisor.AnomalyReporter;

public class ThresholdSupervisor
extends AnomalyReporter {
    private final long maximumProcessingMilliseconds;

    public ThresholdSupervisor(long maximumProcessingMilliseconds) {
        this.maximumProcessingMilliseconds = maximumProcessingMilliseconds;
    }

    @Override
    protected void tookTimeOf(long milliseconds, NewsReceiver<? extends News> listener, News event) {
        super.tookTimeOf(milliseconds, listener, event);
        if (this.maximumProcessingMilliseconds < milliseconds) {
            this.getLogger().warn("The eventbus news listener " + String.valueOf(listener) + " took " + milliseconds + "ms, too long to process the news " + String.valueOf(event));
        }
    }
}

