/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.eventbus.internal.supervisor;

import com.schneide.base.eventbus.News;
import com.schneide.base.eventbus.NewsReceiver;
import com.schneide.base.eventbus.internal.DeliverySupervisor;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.DelayMeasurer;
import com.schneide.base.util.Parameter;

public class AnomalyReporter
extends LoggedObject
implements DeliverySupervisor {
    private DelayMeasurer processingTime = null;

    @Override
    public void deliveryStarted(NewsReceiver<? extends News> listener, News event) {
        this.processingTime = new DelayMeasurer();
    }

    @Override
    public void deliveryStopped(NewsReceiver<? extends News> listener, News event) {
        if (null == this.processingTime) {
            return;
        }
        this.processingTime.stop();
        this.tookTimeOf(this.processingTime.getMillisecondDelay(), listener, event);
    }

    protected void tookTimeOf(long nanoSeconds, NewsReceiver<? extends News> listener, News event) {
        Parameter.arePresent(listener, event);
        if (nanoSeconds < 0L) {
            this.getLogger().warn("Got a negative runtime for event notification. Time anomaly!");
        }
    }
}

