/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.datetime.WallclockTimeout;
import com.schneide.base.threading.SchneideThread;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public class WaitFor {
    public static final WaitFor NOTHING = new WaitFor(0L);
    private final long milliseconds;

    public WaitFor(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long inMillis() {
        return this.milliseconds;
    }

    public Amount<Duration> asDurationAmount() {
        return Amount.valueOf((long)this.inMillis(), (Unit)SI.MILLI((Unit)SI.SECOND));
    }

    public WallclockTimeout asTimeout() {
        return new WallclockTimeout(this.asDurationAmount());
    }

    public void perform() {
        if (!this.isDelaying()) {
            return;
        }
        SchneideThread.performDelay(this.inMillis());
    }

    public boolean isDelaying() {
        return 0L < this.milliseconds;
    }
}

