/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.datetime.PeriodFrom;
import com.schneide.base.timing.Clock;
import javax.measure.quantity.Duration;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.jscience.physics.amount.Amount;

public class Timeout {
    private final ReadablePeriod maximalWait;

    public Timeout(Amount<Duration> duration) {
        this.maximalWait = PeriodFrom.duration(duration);
    }

    public boolean applyOn(TimeConstrainedCheck check) {
        DateTime start = this.getNow();
        while (this.getNow().isBefore((ReadableInstant)start.plus(this.maximalWait))) {
            boolean isFulfilled = check.performAgain();
            if (!isFulfilled) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.maximalWait.toString();
    }

    protected DateTime getNow() {
        return Clock.now();
    }

    public static interface TimeConstrainedCheck {
        public boolean performAgain();
    }
}

