/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.text.StringUtil;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormat;

public class PeriodParser {
    public Period parseFrom(String text) {
        return PeriodFormat.getDefault().parsePeriod(text);
    }

    public static Period fromIso8601(String text, Period defaultValue) {
        if (StringUtil.isEmptyOrNull(text)) {
            return defaultValue;
        }
        try {
            return ISOPeriodFormat.standard().parsePeriod(text);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

