/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.datetime.PeriodParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.joda.time.Period;

public class PeriodInShortFormParser {
    private final Map<String, String> expansions = new HashMap<String, String>();

    public PeriodInShortFormParser() {
        this.expansions.put("s", "seconds");
        this.expansions.put("m", "minutes");
        this.expansions.put("h", "hours");
        this.expansions.put("d", "days");
        this.expansions.put("w", "weeks");
        this.expansions.put("M", "months");
        this.expansions.put("y", "years");
    }

    public Period parseFrom(String text) {
        String normalized = text.replace("min", "m").replace("mutes", "minutes");
        String deflated = this.deflateLongFormsOf(normalized);
        StringBuilder buffer = new StringBuilder();
        for (char character : deflated.toCharArray()) {
            buffer.append(this.replacementFor(character));
        }
        return new PeriodParser().parseFrom(buffer.toString());
    }

    protected String deflateLongFormsOf(String text) {
        String result = text;
        Set<Map.Entry<String, String>> deflations = this.expansions.entrySet();
        for (Map.Entry<String, String> entry : deflations) {
            result = result.replace(entry.getValue(), entry.getKey());
        }
        return result.replace(" ", "");
    }

    private String replacementFor(char character) {
        String key = String.valueOf(character);
        if (!this.expansions.containsKey(key)) {
            return key;
        }
        return " " + this.expansions.get(key);
    }
}

