/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class MetronomFor {
    private final Interval interval;

    public MetronomFor(Interval interval) {
        this.interval = interval;
    }

    public Iterable<DateTime> atEveryFullHour() {
        return this.withDuration(Hours.ONE.toStandardDuration(), this.untilNextHour(this.interval.getStart()));
    }

    protected Duration untilNextHour(DateTime timepoint) {
        if (0 == timepoint.getMinuteOfHour() && 0 == timepoint.getSecondOfMinute() && 0 == timepoint.getMillisOfSecond()) {
            return Duration.ZERO;
        }
        DateTime nextFullHour = timepoint.plusHours(1).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
        return new Duration((ReadableInstant)timepoint, (ReadableInstant)nextFullHour);
    }

    public Iterable<DateTime> withDuration(Duration duration) {
        return this.withDuration(duration, Duration.ZERO);
    }

    protected Iterable<DateTime> withDuration(Duration duration, Duration initialOffset) {
        return () -> new Timepoints(this, this.interval.getStart().plus((ReadableDuration)initialOffset), this.interval.getEnd(), duration);
    }

    private class Timepoints
    implements Iterator<DateTime> {
        private final DateTime end;
        private final Duration advance;
        private DateTime current;

        public Timepoints(MetronomFor metronomFor, DateTime start, DateTime end, Duration advance) {
            this.current = start;
            this.end = end;
            this.advance = advance;
        }

        @Override
        public boolean hasNext() {
            return null != this.current;
        }

        protected DateTime nextTimepoint() {
            return this.current.plus((ReadableDuration)this.advance);
        }

        protected boolean isBeforeEnd(DateTime date) {
            return date.isBefore((ReadableInstant)this.end);
        }

        @Override
        public DateTime next() {
            if (null == this.current) {
                throw new NoSuchElementException("No more timepoints before " + String.valueOf(this.end));
            }
            DateTime next = this.nextTimepoint();
            DateTime result = this.current;
            this.current = null;
            if (this.isBeforeEnd(next)) {
                this.current = next;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by " + this.getClass().getName());
        }
    }
}

