/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datetime;

import com.schneide.base.text.StringUtil;
import com.schneide.base.timing.Clock;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFor {
    private int year = 0;
    private int month = 1;
    private int day = 1;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int millisecond = 0;
    private boolean daylightSaving = true;

    public DateTimeFor year(int newYear) {
        this.year = newYear;
        return this;
    }

    public DateTimeFor month(int newMonth) {
        this.month = newMonth;
        return this;
    }

    public DateTimeFor day(int newDay) {
        this.day = newDay;
        return this;
    }

    public DateTimeFor hour(int newHour) {
        this.hour = newHour;
        return this;
    }

    public DateTimeFor minute(int newMinute) {
        this.minute = newMinute;
        return this;
    }

    public DateTimeFor second(int newSecond) {
        this.second = newSecond;
        return this;
    }

    public DateTimeFor millisecond(int newMillisecond) {
        this.millisecond = newMillisecond;
        return this;
    }

    public DateTimeFor withoutDaylightSaving() {
        this.daylightSaving = false;
        return this;
    }

    public DateTime build() {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond, this.buildTimeZone());
    }

    protected DateTimeZone buildTimeZone() {
        DateTimeZone defaultZone = DateTimeZone.getDefault();
        if (!defaultZone.isFixed() && !this.daylightSaving) {
            return DateTimeZone.forOffsetMillis((int)defaultZone.toTimeZone().getRawOffset());
        }
        return defaultZone;
    }

    public DateTime now() {
        return Clock.now();
    }

    public DateTime string(String representation) {
        if (StringUtil.isEmptyOrNull(representation)) {
            return this.now();
        }
        DateTimeFormatter format = this.getFormatFor(representation);
        if (null == format) {
            throw new NoSuchElementException("Could not find matching datetime pattern for " + representation);
        }
        return format.parseDateTime(representation);
    }

    protected DateTimeFormatter getFormatFor(String representation) {
        DateTimeFormatter result = null;
        for (String pattern : this.getPossibleFormatPatterns()) {
            result = this.returnIfPossible(pattern, representation, result);
        }
        return result;
    }

    protected Iterable<String> getPossibleFormatPatterns() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("yyyy");
        result.add("MM.yyyy");
        result.add("dd.MM.yyyy");
        result.add("dd.MM.yyyy HH:mm");
        result.add("dd.MM.yyyy HH:mm:ss");
        result.add("dd.MM.yyyy HH:mm:ss.SSS");
        result.add("dd.MM.yy");
        result.add("dd.MM.yy HH:mm");
        result.add("dd.MM.yy HH:mm:ss");
        result.add("dd.MM.yy HH:mm:ss.SSS");
        return result;
    }

    protected DateTimeFormatter returnIfPossible(String pattern, String representation, DateTimeFormatter current) {
        if (pattern.length() == representation.length()) {
            return DateTimeFormat.forPattern((String)pattern);
        }
        return current;
    }
}

