/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.counter;

import java.util.function.Consumer;

public class Counter {
    private final int initial;
    private volatile int current;

    public Counter() {
        this(0);
    }

    public Counter(int initialCount) {
        this.initial = initialCount;
        this.current = initialCount;
    }

    public void tick() {
        ++this.current;
    }

    public int current() {
        return this.current;
    }

    public void reset() {
        this.current = this.initial;
    }

    public void atLeast(int threshold, Consumer<Integer> then) {
        int actual = this.current();
        if (actual >= threshold) {
            then.accept(actual);
        }
    }
}

