/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import com.schneide.base.datatypes.collections.iterator.ArrayIterator;
import java.util.Iterator;
import java.util.function.Function;

public class TransformingIterator<ORIGIN, PRODUCT>
implements Iterator<PRODUCT> {
    private final Iterator<ORIGIN> source;
    private Function<ORIGIN, PRODUCT> transformator;

    public TransformingIterator(Function<ORIGIN, PRODUCT> transformator, ORIGIN[] source) {
        this(transformator, new ArrayIterator<ORIGIN>(source));
    }

    public TransformingIterator(Function<ORIGIN, PRODUCT> transformator, Iterator<ORIGIN> source) {
        this.transformator = transformator;
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public PRODUCT next() {
        return this.transformator.apply(this.source.next());
    }
}

