/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SingleElementIterator<T>
implements Iterator<T> {
    private final T element;
    private boolean alreadyReturned;

    public SingleElementIterator(T element) {
        this.element = element;
        this.alreadyReturned = false;
    }

    @Override
    public boolean hasNext() {
        return !this.alreadyReturned;
    }

    @Override
    public T next() {
        if (this.alreadyReturned) {
            throw new NoSuchElementException("No more elements in this single element iterator.");
        }
        this.alreadyReturned = true;
        return this.element;
    }
}

