/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;

public class PeekAheadIterator<T>
implements Iterator<T> {
    private final Predicate<? super T> condition;
    private final Iterator<T> source;
    private Optional<T> next;

    public PeekAheadIterator(Predicate<? super T> condition, Iterator<T> source) {
        this.condition = condition;
        this.source = source;
        this.next = this.peekNext();
    }

    private Optional<T> peekNext() {
        while (this.source.hasNext()) {
            T current = this.source.next();
            if (!this.condition.test(current)) continue;
            return Optional.of(current);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no next element in this iterator.");
        }
        T result = this.next.get();
        this.next = this.peekNext();
        return result;
    }
}

