/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

public class OptionalReducingIterator<T>
implements Iterator<T> {
    private final Iterator<Optional<T>> source;
    private Optional<T> next;

    public OptionalReducingIterator(Iterator<Optional<T>> source) {
        this.source = source;
        this.next = this.peekNext();
    }

    private Optional<T> peekNext() {
        if (this.source.hasNext()) {
            return this.source.next();
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no next element in this iterator.");
        }
        T result = this.next.get();
        this.next = this.peekNext();
        return result;
    }
}

