/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class ConvertingPeekAheadIterator<RESULT, SOURCE>
implements Iterator<RESULT> {
    private final Function<SOURCE, RESULT> conversion;
    private final Predicate<SOURCE> condition;
    private final Iterator<SOURCE> source;
    private Optional<RESULT> next;

    public ConvertingPeekAheadIterator(Function<SOURCE, RESULT> conversion, Predicate<SOURCE> condition, Iterator<SOURCE> source) {
        this.conversion = conversion;
        this.condition = condition;
        this.source = source;
        this.next = this.peekNext();
    }

    private Optional<RESULT> peekNext() {
        while (this.source.hasNext()) {
            SOURCE current = this.source.next();
            if (!this.condition.test(current)) continue;
            RESULT converted = this.conversion.apply(current);
            return Optional.of(converted);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public RESULT next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no next element in this iterator.");
        }
        RESULT result = this.next.get();
        this.next = this.peekNext();
        return result;
    }
}

