/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterator;

import com.schneide.base.datatypes.collections.ArrayUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<TYPE>
implements Iterator<TYPE> {
    private final TYPE[] arrayValues;
    private int currentIndex;

    public ArrayIterator(TYPE[] arrayValues) {
        this.arrayValues = ArrayUtil.copy(arrayValues);
        this.currentIndex = -1;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.arrayValues.length - 1;
    }

    @Override
    public TYPE next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        return this.arrayValues[this.currentIndex];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported by " + this.getClass().getName());
    }
}

