/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.datatypes.collections.iterable;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SubIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final int startIndex;
    private final int maximumLength;

    public SubIterable(Iterable<T> iterable, int startIndex, int maximumLength) {
        this.iterable = iterable;
        this.startIndex = startIndex;
        this.maximumLength = maximumLength;
    }

    public static <T> SubIterable<T> startingAt(int startIndex, Iterable<T> iterable) {
        return new SubIterable<T>(iterable, startIndex, IterableUtil.getSizeFor(iterable) - startIndex);
    }

    public static <T> SubIterable<T> endingAt(int endIndex, Iterable<T> iterable) {
        return new SubIterable<T>(iterable, 0, IterableUtil.getSizeFor(iterable) - endIndex);
    }

    @Override
    public Iterator<T> iterator() {
        return new SubIterator<T>(this.iterable.iterator(), this.startIndex, this.maximumLength);
    }

    protected static class SubIterator<T>
    implements Iterator<T> {
        private final Iterator<T> original;
        private int remaining;

        public SubIterator(Iterator<T> original, int offset, int remaining) {
            this.original = original;
            for (int i = 0; i < offset && this.original.hasNext(); ++i) {
                this.original.next();
            }
            this.remaining = remaining;
        }

        @Override
        public boolean hasNext() {
            boolean result = this.remaining > 0 && this.original.hasNext();
            return result;
        }

        @Override
        public T next() {
            T result = this.original.next();
            if (this.remaining <= 0) {
                throw new NoSuchElementException("Exceeded maximum of allowed elements from this iterator");
            }
            --this.remaining;
            return result;
        }

        @Override
        public void remove() {
            this.original.remove();
        }
    }
}

